% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complr.R
\name{complr}
\alias{complr}
\title{Indices from a (dataset of) Multilevel Composition(s)}
\usage{
complr(data, parts, sbp = NULL, total = 1, idvar = NULL, transform = "ilr")
}
\arguments{
\item{data}{A \code{data.frame} or \code{data.table}
containing data of all variables used in the analysis.
It must include a composition and a ID variable. Required.}

\item{parts}{A character vector specifying the names of compositional variables to be used.
For multiple compositions, a list of character vectors.}

\item{sbp}{A signary matrix indicating sequential binary partition when \code{transform = "ilr"}.
If not supplied, a default sequential binary partition (sbp) will be built using function \code{\link{build.sbp}}.
For multiple compositions, a list of sbps can be supplied.}

\item{total}{A numeric value of the total amount to which the compositions should be closed.
For multiple compositions, a list of numeric values.
Default is \code{1}.}

\item{idvar}{Only for multilevel data, a character string specifying the name of the variable containing participants IDs.}

\item{transform}{A character value naming a log ratio transformation to be applied on compositional data.
Can be either \code{"ilr"} (isometric logratio), \code{"alr"} (additive logratio), or \code{"clr"} (centered logratio).
Default is \code{"ilr"}.}
}
\value{
A \code{\link{complr}} object with at least the following elements.
\item{\code{X}}{ A vector of class \code{acomp} representing one closed composition
or a matrix of class \code{acomp} representing multiple closed  compositions each in one row.}
\item{\code{bX}}{ A vector of class \code{acomp} representing one closed between-person composition
or a matrix of class \code{acomp} representing multiple closed between-person compositions each in one row.}
\item{\code{wX}}{ A vector of class \code{acomp} representing one closed within-person composition
or a matrix of class \code{acomp} representing multiple closed within-person compositions each in one row.}
\item{\code{Z}}{ Log ratio transform of composition.}
\item{\code{bZ}}{ Log ratio transform of between-person composition.}
\item{\code{wZ}}{ Log ratio transform of within-person composition.}
\item{\code{data}}{ The user's dataset or imputed dataset if the iiut data contains zeros.}
\item{\code{transform}}{ Type of transform applied on compositional data.}
\item{\code{parts}}{ Names of compositional variables.}
\item{\code{idvar}}{ Name of the variable containing IDs.}
\item{\code{total}}{ Total amount to which the compositions is closed.}
}
\description{
Compute sets of compositions and log ratio transformation for multilevel compositional data
}
\details{
The \emph{ilr}-transform maps the D-part compositional data from the simplex into non-overlapping
subgroups in the (D-1)-dimension Euclidean space isometrically by using an orthonormal basis,
thereby preserving the compositional properties and yielding a full-rank covariance matrix.
\emph{ilr} transformation should be preferred.
However, the \emph{alr} and \emph{clr} are alternatives.
The \emph{alr}-transform maps a D-part composition
in the Aitchison-simplex non-isometrically to a
(D-1)-dimension Euclidian vectors,
commonly treating the last part as the common denominator of the others.
\emph{alr} transformation does not rely on distance which breaks
the constraint of compositional data.
\emph{clr}-transform maps a D-part composition in the Aitchison-simplex
isometrically to a D-dimensional Euclidian vector subspace.
\emph{clr} transformation is not injetive,
resulting in singular covariance matrices.
}
\examples{
x1 <- complr(data = mcompd,
                parts = c("TST", "WAKE", "MVPA", "LPA", "SB"),
                idvar = "ID", total = 1440)
str(x1)

x2 <- complr(data = mcompd,
                parts = list(c("TST", "WAKE"), c("MVPA", "LPA", "SB")),
                total = list(c(480), c(960)),
                idvar = "ID",
                transform = "ilr")
str(x2)

x3 <- complr(data = mcompd, sbp = sbp,
                parts = c("TST", "WAKE", "MVPA", "LPA", "SB"),
                idvar = "ID",
                 transform = "ilr")
str(x3)

x_wide <- complr(data = mcompd[!duplicated(ID)], sbp = sbp,
                parts = c("TST", "WAKE", "MVPA", "LPA", "SB"))
str(x_wide)
}
