% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projector.R
\name{partial_projector.projector}
\alias{partial_projector.projector}
\title{construct a partial_projector from a \code{projector} instance}
\usage{
\method{partial_projector}{projector}(x, colind, ...)
}
\arguments{
\item{x}{The original \code{projector} instance, typically an object of class \code{bi_projector} or any other class that implements a \code{partial_projector} method}

\item{colind}{A numeric vector of column indices to select in the projection matrix. These indices correspond to the variables used for the partial projector}

\item{...}{Additional arguments passed to the underlying \code{partial_projector} method}
}
\value{
A \code{partial_projector} instance
}
\description{
construct a partial_projector from a \code{projector} instance
}
\examples{

X <- matrix(rnorm(10*10), 10, 10)
pfit <- pca(X, ncomp=9)
proj <- project(pfit, X)

pp <- partial_projector(pfit, 1:5)
}
