% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{prinang}
\alias{prinang}
\title{Compute principal angles for a set of subspaces}
\usage{
prinang(fits)
}
\arguments{
\item{fits}{a list of \code{bi_projector} instances}
}
\value{
a numeric vector of principal angles with length equal to the minimum dimension of input subspaces
}
\description{
This function calculates the principal angles between subspaces derived from a list of bi_projector instances.
}
\examples{

data(iris)
X <- as.matrix(iris[, 1:4])
res <- pca(X, ncomp = 4)
fits_list <- list(res,res,res)
principal_angles <- prinang(fits_list)
}
