% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeineqmat.R
\name{makeineqmat}
\alias{makeineqmat}
\alias{getineqmat}
\title{Define hyperplanes for the Modal Color Theory arrangements}
\usage{
makeineqmat(card)

getineqmat(card)
}
\arguments{
\item{card}{The cardinality of the scale(s) to be studied}
}
\value{
A matrix with \code{card+1} columns and roughly \code{card^(3)/8} rows
}
\description{
As described in Appendix 1.2 of "Modal Color Theory," information about the
defining hyperplane arrangements is stored as a matrix containing the
hyperplanes' normal vectors as rows. (Because these are \strong{mat}rices
and they correspond ultimately to the intervallic \strong{ineq}ualities
that define MCT geometry, this package refers to them as ineqmats, and
sometimes to the individual hyperplanes as \code{ineq}s.) These have already been computed and
are stored as data in this package (\code{ineqmats}) for cardinalities up to 53,
but they can be recreated from scratch with \code{makeineqmat}. This might be
useful if for some reason you need to deal with a huge scale and therefore
want to use an arrangement whose matrix isn't already saved. Note that a
call like \code{makeineqmat(60)} may take a dozen or more seconds to run (and
at sizes that large, the arrangement is terribly complex, with ~17K
distinct hyperplanes).

\code{getineqmat} tests whether the matrix already exists for the desired
cardinality. If so, it is retrieved; if not, it is created using \code{makeineqmat}.
}
\examples{
makeineqmat(2) # Simple: is step 1 > step 2?
makeineqmat(3) # Simple: step 1 > step 2? step 1 > step 3? step 2 > step 3?
makeineqmat(7) # Okay...
ineqmat20 <- makeineqmat(20)
dim(ineqmat20) # Yikes!

}
