% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/axis.R, R/neurospace.R
\name{drop_dim}
\alias{drop_dim}
\alias{drop_dim,AxisSet2D,numeric-method}
\alias{drop_dim,AxisSet2D,missing-method}
\alias{drop_dim,AxisSet3D,numeric-method}
\alias{drop_dim,AxisSet3D,missing-method}
\alias{drop_dim,NeuroSpace,numeric-method}
\alias{drop_dim,NeuroSpace,missing-method}
\title{Drop a Dimension from an Object}
\usage{
drop_dim(x, dimnum)

\S4method{drop_dim}{AxisSet2D,numeric}(x, dimnum)

\S4method{drop_dim}{AxisSet2D,missing}(x, dimnum)

\S4method{drop_dim}{AxisSet3D,numeric}(x, dimnum)

\S4method{drop_dim}{AxisSet3D,missing}(x, dimnum)

\S4method{drop_dim}{NeuroSpace,numeric}(x, dimnum)

\S4method{drop_dim}{NeuroSpace,missing}(x)
}
\arguments{
\item{x}{An AxisSet3D object}

\item{dimnum}{Numeric index of dimension to drop (optional)}
}
\value{
An object of the same class as \code{x} with the specified dimension removed.
}
\description{
This function removes a specified dimension from a given object, such as a matrix or an array.
}
\examples{
# Create a NeuroSpace object with dimensions (10, 10, 10)
x <- NeuroSpace(c(10, 10, 10), c(1, 1, 1))

# Drop the first dimension
x1 <- drop_dim(x, 1)

# Check the new dimensions
ndim(x1) == 2
dim(x1)[1] == 10

}
