% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_import_coding_matrices.R
\name{import_coding_matrices}
\alias{import_coding_matrices}
\title{Read exported NVivo Coding Matrices from a folder}
\usage{
import_coding_matrices(path, recursive = FALSE)
}
\arguments{
\item{path}{(Character) Path to a folder that contains coding matrices
exported from NVivo (\emph{Explore} then \emph{Matrix Coding Query} then \emph{Export Coding Matrix}). All
files with \emph{.XLS} or \emph{.XLSX} extensions will be imported.}

\item{recursive}{(Logical) If \code{TRUE}, also imports files inside subfolders of \code{path}.}
}
\value{
A list of dataframes.
}
\description{
Coding matrices are built inside NVivo's \emph{Matrix Coding Query} tool, with codes
as rows and one participant ("case") as column. These files should be exported as
Excel spreadsheets (XLS or XLSX format), which is the default for NVivo. There
must only be one participant per file.

Filenames \strong{must} reflect the chronological order of interviews when they are
sorted. You can do this by naming them in sequence like \emph{"Interview 07 PID 2345"},
or by including a YMD HM timestamp like \emph{"2023-06-17 1345"}. Sorting is number-aware
and only uses the filename itself (i.e. file path is ignored during sorting).
}
\examples{
# A folder of example coding matrices included with the package
path_to_matrices <- system.file("insect_study/matrices/", package = "novelqualcodes")
print(path_to_matrices)

# A list of files in that folder
list.files(path_to_matrices)

# Import them all at once
my_matrices <- import_coding_matrices(path_to_matrices)

# Look inside the result; each entry of 'my_matrices' is an interview, listed
# in chronological order.
print(my_matrices)

}
\seealso{
\code{\link[=score_codes]{score_codes()}}, \code{\link[=import_field_notes]{import_field_notes()}}
}
