% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNpde-covplot.R
\name{npde.plot.covariate}
\alias{npde.plot.covariate}
\alias{aux.npdeplot.boxcov}
\title{Covariate diagnostic plots}
\usage{
npde.plot.covariate(npdeObject, which.y="npd", ...)
}
\arguments{
\item{npdeObject}{an object returned by a call to \code{\link{npde}} or \code{\link{autonpde}}}

\item{which.y}{a string specifying the variable on the Y-axis (one of "yobs", "npde", "pd", "npd")}

\item{\dots}{additional arguments to be passed on to the function, to control which metric (npde, pd, npd) is used or to override graphical parameters (see the PDF document for details, as well as \code{\link{set.plotoptions}} and \code{\link{npdeControl}})}
}
\value{
a ggplot object or a list of ggplot objects (grobs)
}
\description{
Boxplot of the selected variable versus categories of covariates
}
\details{
For a categorical covariate, boxplots are produced for each category. Continous covariates are split into quantile (by default, first quartile (<Q1), interquartile range (Q1-Q3) and upper quartile (>Q3), but the number of categories can be set by using the ncat argument).

For each category, the median according to simulations under the model is shown (it can be suppressed by using the argument bands=FALSE)..
}
\references{
K. Brendel, E. Comets, C. Laffont, F. Mentre F. Evaluation of different tests based on observations for external model evaluation of population analyses. \emph{Journal of Pharmacokinetics and Pharmacodynamics}, 37:49-65, 2010.
}
\seealso{
\code{\link{npde}}, \code{\link{autonpde}}, \code{\link{set.plotoptions}}, \code{\link{npdeControl}}
}
\author{
Emmanuelle Comets <emmanuelle.comets@bichat.inserm.fr>
}
\keyword{plot}
