% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odbc-connection.R
\docType{data}
\name{SUPPORTED_CONNECTION_ATTRIBUTES}
\alias{SUPPORTED_CONNECTION_ATTRIBUTES}
\alias{ConnectionAttributes}
\title{Supported Connection Attributes}
\description{
These (pre) connection attributes are supported and can be passed as
part of the \code{dbConnect} call in the named list \code{attributes} parameter:
}
\details{
\itemize{
\item \code{azure_token}: This should be a string scalar; in particular Azure Active
Directory authentication token.  Only for use with Microsoft SQL Server and
with limited support away from the OEM Microsoft driver.
\item \code{sf_private_key}: This parameter is specific to establishing a connection
to \code{snowflake} and is understood by both OEM, as well as \code{Posit}
pro drivers.  Argument should be a string (scalar); in particular a
PEM-encoded private key.  Note,
if using private key authentication, the \code{authenticator} connection
string attribute must be set to \code{SNOWFLAKE_JWT}.
Using this \emph{connection} attribute is an alternative to using the
\code{PRIV_KEY_FILE} connection string attribute.
\item \code{sf_private_key_password}: If key passed using \code{sf_private_key} is
encrypted, you can use this attribute to communicate the password.
}
}
\examples{
\dontrun{
conn <- dbConnect(
  odbc::odbc(),
  dsn = "my_azure_mssql_db",
  Encrypt = "yes",
  attributes = list("azure_token" = .token)

conn <- dbConnect(
 odbc::odbc(),
 dsn = "snowflake",
 attributes = list("sf_private_key" = paste(readLines("<path-to-private-key-file>"), collapse="\n"),
                   "sf_private_key_password" = "<optional-private-key-encryption-password>"),
 authenticator = "SNOWFLAKE_JWT")
}
}
\keyword{internal}
