% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.odiffr_batch}
\alias{summary.odiffr_batch}
\alias{print.odiffr_batch_summary}
\title{Summarize Batch Comparison Results}
\usage{
\method{summary}{odiffr_batch}(object, n_worst = 5, ...)

\method{print}{odiffr_batch_summary}(x, ...)
}
\arguments{
\item{object}{An \code{odiffr_batch} object returned by \code{\link[=compare_images_batch]{compare_images_batch()}}
or \code{\link[=compare_image_dirs]{compare_image_dirs()}}.}

\item{n_worst}{Integer; number of worst offenders to include in the summary.
Default is 5.}

\item{...}{Additional arguments (currently unused).}

\item{x}{An \code{odiffr_batch_summary} object.}
}
\value{
An \code{odiffr_batch_summary} object with the following components:
\describe{
\item{total}{Total number of comparisons.}
\item{passed}{Number of matching image pairs.}
\item{failed}{Number of non-matching image pairs.}
\item{pass_rate}{Proportion of passing comparisons (0 to 1).}
\item{reason_counts}{Table of failure reasons (NULL if no failures).}
\item{diff_stats}{List with min, median, mean, max diff percentages
(NULL if no failures with diff data).
}
\item{worst}{Data frame of worst offenders by diff percentage
(NULL if no failures).
}
}
}
\description{
Generate a summary of batch image comparison results, including pass/fail
statistics, failure reasons, and worst offenders.
}
\details{
The summary method expects the standard output of \code{\link[=compare_images_batch]{compare_images_batch()}},
which includes columns: \code{match}, \code{reason}, \code{diff_percentage}, \code{diff_count},
\code{pair_id}, and \code{img2}.
}
\examples{
\dontrun{
# Compare image pairs and summarize
pairs <- data.frame(
  img1 = c("baseline/a.png", "baseline/b.png", "baseline/c.png"),
  img2 = c("current/a.png", "current/b.png", "current/c.png")
)
results <- compare_images_batch(pairs)
summary(results)

# Get summary with more worst offenders
summary(results, n_worst = 10)
}
}
\seealso{
\code{\link[=compare_images_batch]{compare_images_batch()}}, \code{\link[=compare_image_dirs]{compare_image_dirs()}}
}
