% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.1.111.R
\name{power.1.111}
\alias{power.1.111}
\title{Budget and/or sample size, power, MDES calculation for single-level
    randomized controlled trials (RCTs) investigating
    mediation effects}
\usage{
power.1.111(
  cost.model = TRUE,
  expr = NULL,
  constraint = NULL,
  sig.level = 0.05,
  two.tailed = TRUE,
  a = NULL,
  b = NULL,
  power = NULL,
  m = NULL,
  test = NULL,
  n = NULL,
  p = NULL,
  c1 = NULL,
  c1t = NULL,
  r.yx = 0,
  r.mx = 0,
  r.mw = 0,
  q.a = 0,
  q.b = 0,
  max.iter = 300,
  alim = c(0, 4),
  blim = c(0.01, 0.99),
  powerlim = NULL,
  nlim = c(6, 1e+07),
  mlim = NULL
)
}
\arguments{
\item{cost.model}{Logical; power analyses accommodating costs and budget
(e.g., required budget for a desired power, power under fixed budget)
if TRUE. Otherwise, conventional power analyses are performed
(e.g., required sample size and power calculation); default value is TRUE.}

\item{expr}{Returned object from function \code{\link{od.1.111}}; default value is NULL;
if \code{expr} is specified, parameter values of \code{a}, \code{b},
\code{c}, \code{ct}, and \code{p}
used or solved in function \code{\link{od.1.111}} will
be passed to the current function;
only the values of \code{p} that specified or solved in
function \code{\link{od.1.111}} can be overwritten
if \code{constraint} is specified.}

\item{constraint}{If specified, the constrained value of
\code{p} in a list format (e.g., constraint = list(p = 0.5))
will overwrite that
from \code{expr}; default value is NULL.}

\item{sig.level}{Significance level or type I error rate, default value is 0.05.}

\item{two.tailed}{Two tailed test, the default value is TRUE.}

\item{a}{The treatment effect on the mediator.}

\item{b}{The within-treatment correlation between the outcome and
the mediator.}

\item{power}{Statistical power specified, default is .80.}

\item{m}{Total budget.}

\item{test}{The type of test will be used to detect mediation effects.
The default is the NULL or the one used in the expr
Choices are the joint significance test (i.e., test = "joint",
"Joint","JOINT") or the Sobel test (test = "sobel", "Sobel", or "SOBEL").}

\item{n}{Total number of individuals in the experimental study, the default
value is NULL.}

\item{p}{The proportion of level-4 clusters/units to be assigned to treatment.}

\item{c1}{The cost of sampling an individual in the control group.}

\item{c1t}{The cost of sampling an individual in the treated group.}

\item{r.yx}{The within-treatment correlation between the outcome and the
covariate(s) in the outcome model.}

\item{r.mx}{The within-treatment correlation between the mediator and the
covariate(s) in the outcome model.}

\item{r.mw}{The within-treatment correlation between the mediator and the
covariate(s) in the mediator model.}

\item{q.a}{The number of covariates at the mediator model
(except the treatment indicator), the default value is zero.}

\item{q.b}{The number of covariates in the outcome model (except the treatment
indicator and the mediator), the default value is zero.}

\item{max.iter}{Maximal number of function evaluations when used as
the stopping criterion. Default is 300.}

\item{alim}{The range for identifying the root of a path
effect (\code{a}) numerically. Default value is c(0, 4).}

\item{blim}{The range for identifying the root of b path within-treatment
correlation between the mediator and outcome (\code{b}) numerically.
Default value is (.01, .99), if (\code{b}) is negative, please re-code
the outcome or mediator to make it positive.}

\item{powerlim}{The range for solving the root of power (\code{power}) numerically,
default value is c(1e-10, 1 - 1e-10).}

\item{nlim}{The interval/range used to numerically solve for n,
the default values are c(6, 1e7).}

\item{mlim}{The range for identifying the root of budget (\code{m}) numerically,
default value is the costs sampling \code{nlim} units.}
}
\value{
Required budget (or required sample size), statistical power,
    (\code{a}) , or (\code{b})  depending on the specification of parameters.
    The function also returns the function name, design type,
    and parameters used in the calculation.
}
\description{
This function can calculate required budget for desired power and
    power under a fixed budget
    for RCTs probing mediation effects.
    It also can perform conventional power analyses
    (e.g., required sample size and power calculation).
}
\examples{
# Optimal design and power analyses accommodating costs and budget
myod <- od.1.111(a = .3, b = .5, c1 = 10, c1t = 100)
# myod
mypower <- power.1.111(expr = myod, power = .8)
#mypower

# Conventional power analyses
mypower <- power.1.111(cost.model = FALSE, a = .3, b = .5, test = "joint",
                       power = .8, p =.5)
#mypower
mypower <- power.1.111(cost.model = FALSE, n = 350, b = .5, test = "joint",
                       power = .8, p =.5)
#mypower

}
