% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_fill.R
\name{opt_fill}
\alias{opt_fill}
\title{opt_fill}
\usage{
opt_fill(x, opts = commandArgs(), style = getOption("optigrab")$style)
}
\arguments{
\item{x}{list-like (recursive)) object with names to use as a template.}

\item{opts}{character command-line option list (Default: commandArgs() )}

\item{style}{string; the command-line style (Default: getOption('optigrab')$style}
}
\value{
(A copy of) \code{x}, with values filled from the command-line.  If
\code{x} is a reference structure, this is done by reference, returning
the object invisibly.
}
\description{
Fill a recursive structure with command-line arguments
}
\details{
\code{opt_fill} uses \code{x} as a template of values to be retrieved. Named elements
of \code{x} are retrieved from the command line using \code{\link[=opt_get]{opt_get()}}. Values are
coerced to the type/class of the elements of x.

This gives a handy way of defining and retrieving all setting at once
overridding the defaults.

\code{opt_fill} is similar to \code{\link[utils:modifyList]{utils::modifyList()}} but does not work recursively.
}
\examples{
  defaults <- list( foo="a", bar=1 )
  
  opt_fill( defaults, opts=c( '--foo', 'command-line-foo' ))
  opt_fill( defaults, opts=c( '--foo', 'command-line-foo', '--bar', '9999' ))
 
  defaults <- as.environment(defaults)
  opt_fill( defaults, opts=c( '--foo', 'env-fill', '--bar', '555' ))
  
  str( as.list(defaults) )

}
\seealso{
\code{\link[=opt_get]{opt_get()}}
\code{\link[utils:modifyList]{utils::modifyList()}}
}
