% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_get_args.R
\name{opt_get_args}
\alias{opt_get_args}
\title{Return arguments to Rscript}
\usage{
opt_get_args(opts = commandArgs())
}
\arguments{
\item{opts}{character; vector of arguments, (Default: \code{commandArgs()})

Returns the user provided arguments, i.e. those following (the first) 
\code{--args} flag. This is identical to what is done by 
\code{commandArgs( trailingOnly = TRUE )} does. This is included an used 
since it supports testing/modifying the \code{commandArgs} array.}
}
\value{
character; vector stripping elements preceding and
including (the first) \code{--args} flag.
}
\description{
Arguments to a script are those following the \code{--args} argument.
}
\examples{
  opt_get_args()
  opt_get_args( opts=c( "Rscript", "-a", "-b", "--args", "-c", 3, "-d" ) )  # "-c" "3" "-d"
  opt_get_args( opts=c( "-a", "-b", "--args", "-c", "--args", "-d" ) )  # "-c" "-d"
  opt_get_args( opts=c( "--foo", "bar") ) 
  
}
\seealso{
\itemize{
\item \code{\link[base:commandArgs]{base::commandArgs()}} \cr
\item \code{\link[=opt_grab]{opt_grab()}} \cr
}
}
