% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare-lpr.R
\name{prepare_lpr2}
\alias{prepare_lpr2}
\title{Prepare and join the two LPR2 registers to extract diabetes and pregnancy diagnoses.}
\usage{
prepare_lpr2(lpr_adm, lpr_diag)
}
\arguments{
\item{lpr_adm}{The LPR2 register containing hospital admissions.}

\item{lpr_diag}{The LPR2 register containing diabetes diagnoses.}
}
\value{
The same type as the input data, as a \code{\link[duckplyr:duckdb_tibble]{duckplyr::duckdb_tibble()}},
with the following columns:
\itemize{
\item \code{pnr}: The personal identification variable.
\item \code{date}: The date of all the recorded diagnosis (renamed from
\code{d_inddto} or \code{dato_start}).
\item \code{is_primary_diagnosis}: Whether the diagnosis was a primary diagnosis.
\item \code{is_diabetes_code}: Whether the diagnosis was any type of diabetes.
\item \code{is_t1d_code}: Whether the diagnosis was T1D-specific.
\item \code{is_t2d_code}: Whether the diagnosis was T2D-specific.
\item \code{is_pregnancy_code}: Whether the person has an event related to
pregnancy like giving birth or having a miscarriage at the given date.
\item \code{is_endocrinology_dept}: Whether the diagnosis was made by an
endocrinology medical department.
\item \code{is_medical_dept}: Whether the diagnosis was made by a
non-endocrinology medical department.
}
}
\description{
The output is used as inputs to \code{\link[=keep_diabetes_diagnoses]{keep_diabetes_diagnoses()}} and to
\code{\link[=keep_pregnancy_dates]{keep_pregnancy_dates()}}.
}
\seealso{
See the \code{vignette("algorithm")} for the logic used to filter these
patients.
}
\keyword{internal}
