% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_randomforest.R
\name{fit_rf_metamodel}
\alias{fit_rf_metamodel}
\title{Fit random forest metamodel}
\usage{
fit_rf_metamodel(
  df,
  y_var = NULL,
  x_vars = NULL,
  ntree = 500,
  seed_num = 1,
  tune = FALSE,
  var_importance = FALSE,
  pm_plot = FALSE,
  pm_vars = x_vars[1],
  validation = FALSE,
  folds = 5,
  show_intercept = FALSE,
  partition = 1,
  fit_complete_model = TRUE
)
}
\arguments{
\item{df}{a dataframe.}

\item{y_var}{character. Name of the output variable in the dataframe. This will be the dependent variable of the metamodel.}

\item{x_vars}{character or a vector for characters. Name of the input variable(s) in the dataframe. This will be the independent variable of the metamodel.}

\item{ntree}{Number of trees to grow.}

\item{seed_num}{numeric. Determine which seed number to use to split the dataframe in fitting an validation sets.}

\item{tune}{logical. Determine whether nodesize and mtry should be tuned. Nodesize is the minimum size of terminal nodes, mtry is number of variables to possibly split at each node. If FALSE, nodesize = 15 (for regression), and mtry = number of x-variables / 3 (for regression). Default is FALSE.}

\item{var_importance}{logical or character. Determine whether to compute variable importance (TRUE/FALSE), or how to compute variable importance (permute/random/anti). Default is FALSE. TRUE corresponds to "anti".}

\item{pm_plot}{logical or character. Determine whether to plot the partial ("partial") or marginal ("marginal") effect or both ("both") of an x-variable (which is denoted by pm_vars). Default is FALSE. TRUE corresponds to "both".}

\item{pm_vars}{character. Name of the input variable(s) for the partial/marginal plot. Default is the first variable from the x_vars.}

\item{validation}{logical or character. Determine whether to validate the RF model. Choices are "test_train_split" and "cross-validation". TRUE corresponds to "cross-validation", default is FALSE.}

\item{folds}{numeric. Number of folds for the cross-validation. Default is 5.}

\item{show_intercept}{logical. Determine whether to show the intercept of the perfect prediction line (x = 0, y = 0). Default is FALSE.}

\item{partition}{numeric. Value between 0 and 1 to determine the proportion of the observations to use to fit the metamodel. Default is 1 (fitting the metamodel using all observations).}

\item{fit_complete_model}{logical. Determine whether to fit the (final) full model. So the model trained on all available data (as opposed to the model used in validation which is trained on the test data).}
}
\value{
A list containing the following elements:
 \itemize{
  \item fit: a list, see \code{\link[randomForestSRC:rfsrc]{randomForestSRC::rfsrc()}} for a description of the outputs contained in this list.
  \item model_info: a list containing the following elements:
   \itemize{
     \item x_vars: vector of names of parameters included in the metamodel;
     \item y_var: name outcome variable;
     \item form: formula of the metamodel based on `x_vars` and `y_var`;
     \item data: dataframe containing the inputs and output values used to fit (and fit) the metamodel;
     \item type: "rf" for "random forest".}
 \item (if `tune` = TRUE) tune_fit: a list containing the results of the tuning process, see \code{\link[randomForestSRC:tune]{randomForestSRC::tune()}} for a description of the elements containd in this list.
 \item (if `tune` = TRUE) tune_plot: plot showing the out-of-bag error for each tested combination of 'mtry' and 'nodesize'.
 \item (if validation != FALSE) stats_validation: data frame containing the R-squared, Mean absolute error, Mean relative error, Mean squared error in the test validation set.
 \item (if validation = "test_train_split") calibration_plot: plot showing the rf-predicted versus observed output values in the test validation set.}
If `var_importance` is set to TRUE, the variable importance plot is printed in the console.
If `pm_plot`is used, the marginal/ partial importance plot(s) - drawn using \code{\link[randomForestSRC:plot.variable.rfsrc]{randomForestSRC::plot.variable.rfsrc()}} - is (are) printed in the console.
}
\description{
This function fits a random forest metamodel using the \code{\link[randomForestSRC]{randomForestSRC}} package.
}
\examples{
# Fitting and tuning a random forest meta model with two variables using the example data
data(df_pa)
\donttest{
fit_rf_metamodel(df = df_pa,
                 y_var = "inc_qaly",
                 x_vars = c("p_pfsd", "p_pdd"),
                 tune = FALSE
                 )}
}
