% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openai_batch_api.R
\name{openai_poll_batch_until_complete}
\alias{openai_poll_batch_until_complete}
\title{Poll an OpenAI batch until it completes or fails}
\usage{
openai_poll_batch_until_complete(
  batch_id,
  interval_seconds = 5,
  timeout_seconds = 600,
  max_attempts = Inf,
  api_key = NULL,
  verbose = TRUE
)
}
\arguments{
\item{batch_id}{The batch ID.}

\item{interval_seconds}{Number of seconds to wait between polling attempts.}

\item{timeout_seconds}{Maximum total time to wait in seconds before
giving up.}

\item{max_attempts}{Maximum number of polling attempts. This is mainly useful
for testing; default is \code{Inf}.}

\item{api_key}{Optional OpenAI API key.}

\item{verbose}{Logical; if \code{TRUE}, prints status messages to the console.}
}
\value{
The final Batch object (a list) as returned by \code{\link[=openai_get_batch]{openai_get_batch()}}.
}
\description{
Repeatedly calls \code{\link[=openai_get_batch]{openai_get_batch()}} until the batch reaches a terminal
status (one of \code{"completed"}, \code{"failed"}, \code{"cancelled"}, \code{"expired"}),
a timeout is reached, or \code{max_attempts} is exceeded.
}
\details{
This is a synchronous helper – it will block until one of the conditions
above is met.
}
\examples{
\dontrun{
# Requires OPENAI_API_KEY and a created batch that may still be running.

batch <- openai_create_batch("file_123", endpoint = "/v1/chat/completions")

final <- openai_poll_batch_until_complete(
  batch_id         = batch$id,
  interval_seconds = 10,
  timeout_seconds  = 3600
)

final$status
}

}
