% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_records.R
\name{get_records}
\alias{get_records}
\title{Query Species Occurrence Records within an Area of Interest (AOI)}
\usage{
get_records(
  species,
  aoi_sf,
  providers = NULL,
  limit = 500,
  remove_duplicates = FALSE,
  date = NULL
)
}
\arguments{
\item{species}{Character string specifying the species name to query (e.g., "Puma concolor").}

\item{aoi_sf}{An \code{sf} object defining the Area of Interest (AOI). Its CRS will be
transformed to WGS84 (\code{EPSG:4326}) before query.}

\item{providers}{Character vector of data providers to query (e.g., "gbif", "inat").
If \code{NULL} (default), all available providers are used.}

\item{limit}{Numeric. The maximum number of records to retrieve per provider. Default is 500.}

\item{remove_duplicates}{Logical. If \code{TRUE}, records with identical longitude and
latitude are removed using \code{dplyr::distinct()}. Default is \code{FALSE}.}

\item{date}{Character vector specifying a date range (e.g., \code{c('2000-01-01', '2020-12-31')}).}
}
\value{
An \code{sf} object of points containing the filtered occurrence records,
  with geometry confirmed to fall strictly within the \code{aoi_sf} boundary.
}
\description{
Downloads species occurrence records from providers (e.g., GBIF) using the \code{spocc}
package, filtering the initial query by the exact polygonal boundary of the
Area of Interest (AOI) for maximum efficiency and precision.
}
\details{
The function transforms the \code{aoi_sf} polygon into a WKT string, which is used in
the \code{spocc::occ} geometry argument. This method is more efficient than querying
by the rectangular bounding box, as it reduces the number of irrelevant records downloaded.
Final spatial filtering is performed using \code{sf::st_intersection} to ensure strict
containment.
}
\examples{
\dontrun{
# Assuming aoi_sf is a valid sf polygon
# puma_records <- get_records("Puma concolor", aoi_sf, providers = "gbif", limit = 1000)
# head(puma_records)
}
}
