% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{rawCoords}
\alias{rawCoords}
\title{Raw coordinates}
\usage{
rawCoords(df, ...)
}
\arguments{
\item{df}{data frame}

\item{...}{other expected values of getCoords}
}
\value{
matrix with coordinate representation of all points
}
\description{
Returns the input data frame. This is used when other coordinate computations fail.
In general, scaling of the inputs is recommended before clustering.
}
\details{
Externally calculated coordinates can be used through userCoords or
as input data with rawCoords used as the coordinate function.
The use of userCoords over rawCoords is in the treatment of input data.
As pandemonium displays the input data in many plots the use of coordinates
as input data will result in these plots being less meaningful for interpretation.
Use userCoords where coordinates are necessary to calculate distances but
interpretation from plots of clustering space is necessary.
}
\examples{
head(rawCoords(Bikes$space2))


}
