% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasource.R
\name{ds_write_delta}
\alias{ds_write_delta}
\title{Write FHIR data to Delta files}
\usage{
ds_write_delta(ds, path, save_mode = SaveMode$OVERWRITE)
}
\arguments{
\item{ds}{The DataSource object.}

\item{path}{The URI of the directory to write the files to.}

\item{save_mode}{The save mode to use when writing the data - "overwrite" will overwrite any
existing data, "merge" will merge the new data with the existing data based on resource ID.}
}
\value{
A list with element \code{file_infos}, containing a list of files created.
  Each file has \code{fhir_resource_type} and \code{absolute_url}.
}
\description{
Writes the data from a data source to a directory of Delta files.
}
\examples{
\dontshow{if (pathling_is_spark_installed()) withAutoprint(\{ # examplesIf}
pc <- pathling_connect()
data_source <- pc \%>\% pathling_read_ndjson(pathling_examples("ndjson"))

# Write the data to a directory of Delta files.
data_source \%>\% ds_write_delta(file.path(tempdir(), "delta"), save_mode = SaveMode$OVERWRITE)

pathling_disconnect(pc)
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://pathling.csiro.au/docs/libraries/io#delta-lake-1}{Pathling documentation - Writing Delta}

\code{\link{SaveMode}}

Other data sink functions: 
\code{\link{ds_write_ndjson}()},
\code{\link{ds_write_parquet}()},
\code{\link{ds_write_tables}()}
}
\concept{data sink functions}
