% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcoxph.R
\name{pcoxph}
\alias{pcoxph}
\title{Profile Boosting for Cox proportional hazards Model}
\usage{
pcoxph(
  formula,
  data,
  weights,
  subset,
  na.action,
  init,
  control,
  ties = c("efron", "breslow", "exact"),
  singular.ok = TRUE,
  robust,
  model = FALSE,
  x = FALSE,
  y = TRUE,
  tt,
  method = ties,
  id,
  cluster,
  istate,
  statedata,
  nocenter = c(-1, 0, 1),
  ...,
  stopFun = EBIC,
  keep = NULL,
  maxK = NULL,
  verbose = FALSE
)
}
\arguments{
\item{formula}{See \link{pboost}.}

\item{data}{See \link{pboost}.}

\item{weights}{Parameters passed to \link[survival:coxph]{survival::coxph}.}

\item{subset}{Parameters passed to \link[survival:coxph]{survival::coxph}.}

\item{na.action}{Parameters passed to \link[survival:coxph]{survival::coxph}.}

\item{init}{Parameters passed to \link[survival:coxph]{survival::coxph}.}

\item{control}{Parameters passed to \link[survival:coxph]{survival::coxph}.}

\item{ties}{Parameters passed to \link[survival:coxph]{survival::coxph}.}

\item{singular.ok}{Parameters passed to \link[survival:coxph]{survival::coxph}.}

\item{robust}{Parameters passed to \link[survival:coxph]{survival::coxph}.}

\item{model}{Parameters passed to \link[survival:coxph]{survival::coxph}.}

\item{x}{Parameters passed to \link[survival:coxph]{survival::coxph}.}

\item{y}{Parameters passed to \link[survival:coxph]{survival::coxph}.}

\item{tt}{Parameters passed to \link[survival:coxph]{survival::coxph}.}

\item{method}{Parameters passed to \link[survival:coxph]{survival::coxph}.}

\item{id}{Parameters passed to \link[survival:coxph]{survival::coxph}.}

\item{cluster}{Parameters passed to \link[survival:coxph]{survival::coxph}.}

\item{istate}{Parameters passed to \link[survival:coxph]{survival::coxph}.}

\item{statedata}{Parameters passed to \link[survival:coxph]{survival::coxph}.}

\item{nocenter}{Parameters passed to \link[survival:coxph]{survival::coxph}.}

\item{...}{Parameters passed to \link[survival:coxph]{survival::coxph}.}

\item{stopFun}{Parameters passed to \link{pboost}.}

\item{keep}{Parameters passed to \link{pboost}.}

\item{maxK}{Parameters passed to \link{pboost}.}

\item{verbose}{Parameters passed to \link{pboost}.}
}
\value{
An \code{coxph} model object fitted on the selected features.
}
\description{
Profile boosting for Cox model.
}
\examples{
library(survival)
set.seed(2025)
n <- 300
p <- 200

DF <- data.frame(
    time = rpois(n, 5),
    status = rbinom(n, 1, 0.3),
    matrix(rnorm(n*p), n)
)

pcoxph(Surv(time, status) ~ ., DF, verbose=TRUE)

}
