% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-foreign2mspct.r
\name{read_foreign2mspct}
\alias{read_foreign2mspct}
\title{Read multiple foreign files with spectral data}
\usage{
read_foreign2mspct(path = ".", list = NULL, pattern = NULL, .fun, ...)
}
\arguments{
\item{path}{character A path point to the location of the files.}

\item{list}{character A vector or list of character strings pointing to
files relative to \code{path},}

\item{pattern}{character A search pattern to select files within \code{path}.
See \code{\link{list.files}} which is used internally. Argument ignored
is list is non-null.}

\item{.fun}{function One of the functions exported by this package for
reading spectral data.}

\item{...}{Named arguments passed ot the call to \code{.fun}.}
}
\value{
An object of class `generic_mspct` or a class derived from it, 
  containing a collection of member spectra of class `generic_spct` or of 
  one of the classes derived from it.
}
\description{
Read spectra from a homogeneous list of files based on a path and a list of
filenames or a path and a search pattern for files. The imported spectra are
returned as a single object of one of the collection of spectra classes from
package 'photobiology'.
}
\details{
This function iterates over a list of file names reading them with
  the function passed as argument to `.fun` and combines the spectra as a
  collection of spectra of a class suitable for the spectral objects returned
  by the argument to `.fun`. This function can either return for each file
  read either a single spectrum as an object of class `generic_spct` or a
  class derived from it, or a collection of spectra of class `generic_mspct`
  or a class derived from it. The class of the returned object depends on
  the class of the member spectra.
}
