% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.new.r
\name{as.response_spct}
\alias{as.response_spct}
\alias{as.response_spct.default}
\alias{as.response_spct.waveband}
\title{Coerce to a spectrum}
\usage{
as.response_spct(x, ...)

\method{as.response_spct}{default}(x, time.unit = "second", ...)

\method{as.response_spct}{waveband}(
  x,
  time.unit = "second",
  w.length = NULL,
  fill = 0,
  unit.in = getOption("photobiology.radiation.unit", default = "energy"),
  unit.out = unit.in,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{x}{an R object.}

\item{...}{other arguments passed to "set" functions.}

\item{time.unit}{character string indicating the time unit used for spectral
irradiance or exposure (\code{"second"}, \code{"day"} or \code{"exposure"})
or an object of class duration as defined in package lubridate.}

\item{w.length}{numeric vector of wavelengths (nm).}

\item{fill}{value to use as response for wavelengths outside the waveband
range.}

\item{unit.in, unit.out}{the type of unit we assume as reference: "energy" or
"photon" based for the waveband definition and the implicit matching
response plotted.}

\item{strict.range}{logical Flag indicating whether off-range values result
in an error instead of a warning.}

\item{na.rm}{logical.}
}
\value{
A copy of \code{x} converted into a \code{response_spct} object.
}
\description{
Return a copy of an R object with its class set to a given type of spectrum.
}
\section{Methods (by class)}{
\itemize{
\item \code{as.response_spct(default)}: 

\item \code{as.response_spct(waveband)}: 

}}
\seealso{
\code{\link{setGenericSpct}}

Other constructors of spectral objects: 
\code{\link{as.calibration_spct}()},
\code{\link{as.chroma_spct}()},
\code{\link{as.cps_spct}()},
\code{\link{as.filter_spct}()},
\code{\link{as.generic_spct}()},
\code{\link{as.object_spct}()},
\code{\link{as.raw_spct}()},
\code{\link{as.reflector_spct}()},
\code{\link{as.solute_spct}()},
\code{\link{as.source_spct}()},
\code{\link{source_spct}()}
}
\concept{constructors of spectral objects}
