% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psic.R
\name{get_psic}
\alias{get_psic}
\title{Philippine Standard Industrial Classification (PSIC)}
\usage{
get_psic(
  ...,
  token = NULL,
  version = NULL,
  level = NULL,
  harmonize = TRUE,
  minimal = TRUE,
  cols = NULL
)
}
\arguments{
\item{...}{See \code{?dplyr::filter}. Expressions that return a logical value, and are defined in terms of the variables in returned data. If multiple expressions are included, they are combined with the & operator. Only rows for which all conditions evaluate to TRUE are kept.}

\item{token}{Character. API access token.}

\item{version}{Character. Version of the PSIC dataset. Default is \code{NULL}. If \code{NULL}, the latest version is used.}

\item{level}{Character. Classification level such as \code{"all"}, \code{"sections"}, \code{"divisions"}, \code{"groups"}, \code{"classes"}, and \code{"sub-classes"}.}

\item{harmonize}{Logical. If \code{TRUE}, formats and standardizes the returned data. Default is \code{TRUE}.}

\item{minimal}{Logical. If \code{TRUE}, returns a simplified dataset. Default is \code{TRUE}.}

\item{cols}{Optional. Character vector of additional columns to include when \code{minimal = FALSE}.}
}
\value{
A data frame of PSIC classifications.
}
\description{
Philippine Standard Industrial Classification (PSIC)
}
\examples{
\dontrun{
get_psic(token = "your_api_token")
}
# If token is not provided, the function will fetch from local cache or
# download the latest version from remote repo
psic <- get_psic()

# Get specific level
psic_filtered <- get_psic(level = "sections")
psic_filtered
}
\references{
\url{https://psa.gov.ph/classification/psic}
}
