% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ps_get_comm}
\alias{ps_get_comm}
\title{Get \code{phylospatial} community data}
\usage{
ps_get_comm(ps, tips_only = TRUE, spatial = TRUE)
}
\arguments{
\item{ps}{\code{phylospatial} object.}

\item{tips_only}{Logical indicating whether only the terminal taxa (TRUE, the default) or all taxa (FALSE) should be returned.}

\item{spatial}{Logical indicating whether a spatial (\code{SpatRaster} or \code{sf}) object should be returned. Default is \code{TRUE};
if \code{FALSE}, a matrix is returned.}
}
\value{
Either a \code{SpatRaster} with a layer for every taxon, or an \code{sf} data frame with a variable for every taxon,
depending on which data type was used to create \code{ps}.
}
\description{
Get \code{phylospatial} community data
}
\examples{
ps <- ps_simulate()

# the defaults return a spatial object of terminal taxa distributions:
ps_get_comm(ps)

# get distributions for all taxa, as a matrix
pcomm <- ps_get_comm(ps, tips_only = FALSE, spatial = FALSE)

}
