% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piecemeal-package.R
\docType{package}
\name{piecemeal-package}
\alias{piecemeal}
\alias{piecemeal-package}
\title{piecemeal: Wrangle Large Simulation Studies}
\description{
An 'R6' class to set up, run, monitor, collate, and debug large simulation studies comprising many small independent replications and treatment configurations. Parallel processing, reproducibility, fault- and error-tolerance, and ability to resume an interrupted or timed-out simulation study are built in.
}
\details{
This package grew out of a common problem of running a simulation with large numbers of treatment combinations and replications on a shared computing cluster. Using available tools such as \pkg{parallel} and even \CRANpkg{foreach} can be frustrating for a number of reasons:
\itemize{
\item If any of the function runs results in an error, all results are lost.
\item Tracking down which configuration resulted in an error and reproducing it can be frustrating, and if the fix does not fix all the errors, one has to start over.
\item If one underestimates the amount of time all the jobs will take, all results are lost.
\item Conversely, if the cluster turns out to be freer than anticipated, it is desirable to queue another job to get things done twice as fast.
}

Those package with fault-tolerance capabilities typically focus on crashing worker nodes.

This can be worked around in a variety of ways. Functions can be wrapped in \code{\link[=try]{try()}}. Rather than returning the result to the manager process, the worker can save its results to a unique file, with the results collated at the end. \code{\link{Piecemeal}} automates this, and keeps careful track of inputs and random seeds, ensuring that problematic realisations can be located and debugged quickly and efficiently. A locking system even makes it possible to have multiple jobs running the same study on the same cluster without interfering with each other.
}
\seealso{
The \code{\link{Piecemeal}} \code{\link[R6:R6Class]{R6}} class for details, the \href{../doc/piecemeal.html}{vignette (\code{vignette("piecemeal")})} for a worked example, and files in \file{examples/} for a typical setup on a cluster.
}
\author{
\strong{Maintainer}: Pavel N. Krivitsky \email{pavel@statnet.org} (\href{https://orcid.org/0000-0002-9101-3362}{ORCID})

}
