% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stats.R
\name{get_stats}
\alias{get_stats}
\alias{get_wb}
\alias{get_agg}
\title{Get poverty and inequality statistics}
\usage{
get_stats(
  country = "all",
  year = "all",
  povline = NULL,
  popshare = NULL,
  fill_gaps = FALSE,
  nowcast = FALSE,
  subgroup = NULL,
  welfare_type = c("all", "income", "consumption"),
  reporting_level = c("all", "national", "urban", "rural"),
  version = NULL,
  ppp_version = NULL,
  release_version = NULL,
  api_version = "v1",
  format = c("arrow", "rds", "json", "csv"),
  simplify = TRUE,
  server = NULL
)

get_wb(
  year = "all",
  povline = NULL,
  version = NULL,
  ppp_version = NULL,
  release_version = NULL,
  api_version = "v1",
  format = c("rds", "json", "csv"),
  simplify = TRUE,
  server = NULL
)

get_agg(
  year = "all",
  povline = NULL,
  version = NULL,
  ppp_version = NULL,
  release_version = NULL,
  aggregate = NULL,
  api_version = "v1",
  format = c("rds", "json", "csv"),
  simplify = TRUE,
  server = NULL
)
}
\arguments{
\item{country}{character: A vector with one or more \href{https://wits.worldbank.org/wits/wits/witshelp/content/codes/country_codes.htm}{country ISO 3 codes} or
'all'}

\item{year}{integer: A vector with one or more years or 'all'}

\item{povline}{numeric: Poverty line}

\item{popshare}{numeric: Proportion of the population living below the
poverty line}

\item{fill_gaps}{logical: If TRUE, will interpolate / extrapolate values for
missing years}

\item{nowcast}{logical: If TRUE, will return nowcast estimates.}

\item{subgroup}{character: If used result will be aggregated for predefined
sub-groups. Either 'wb_regions' or 'none'.}

\item{welfare_type}{character: Welfare type either of c("all", "income", "consumption")}

\item{reporting_level}{character: Geographical reporting level either of c("all", "national", "urban", "rural")}

\item{version}{character: Data version. See \code{get_versions()}}

\item{ppp_version}{ppp year to be used}

\item{release_version}{date when the data was published in YYYYMMDD format}

\item{api_version}{character: API version}

\item{format}{character: Response format either of c("rds", "json", "csv")}

\item{simplify}{logical: If TRUE (the default) the response is returned as a
\code{tibble}}

\item{server}{character: Server. For WB internal use only}

\item{aggregate}{character: Aggregate name. See \code{get_aux("countries")} for available options.}
}
\value{
If \code{simplify = FALSE}, it returns a list of class "pip_api". If
\code{simplify = TRUE}, it returns a tibble with the requested data. This is the
default. Only for \code{get_aux()}, If \code{assign_tb = TRUE} or character, it
returns TRUE when data was assign properly to .pip env. FALSE, if it was
not assigned.
}
\description{
Get poverty and inequality statistics
}
\examples{
\dontrun{
# One country-year
res <- get_stats(country = "AGO", year = 2000)

# All years for a specific country
res <- get_stats(country = "AGO", year = "all")

# All countries and years
res <- get_stats(country = "all", year = "all")

# All countries and years w/ alternative poverty line
res <- get_stats(country = "all", year = "all", povline = 3.2)

# Fill gaps for years without available survey data
res <- get_stats(country = "all", year = "all", fill_gaps = TRUE)

# Proportion living below the poverty line
res <- get_stats(country = "all", year = "all", popshare = .4)

# World Bank global and regional aggregates
res <- get_stats("all", year = "all", subgroup = "wb")

# Short hand to get WB global/regional stats
res <- get_wb()

# Short hand to get fcv stats
res <- get_agg(aggregate = "fcv", server = "qa")

# Custom aggregates
res <- get_stats(c("ARG", "BRA"), year = "all", subgroup = "none")
}
}
