% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExactSeparation.R
\name{ExactSeparation}
\alias{ExactSeparation}
\title{Exact separation matrices computation.}
\usage{
ExactSeparation(poset, output_every_sec = NULL, type, ...)
}
\arguments{
\item{poset}{Object of S4 class \code{POSet} representing the poset whose separation matrix is computed.
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}

\item{output_every_sec}{Integer specifying a time interval (in seconds).
By specifying this argument, during the execution of \code{BubleyDyerSeparation}, a message reporting the number of linear extensions
progressively generated is printed on the R-Console, every \code{output_every_sec} seconds.}

\item{type}{type of separation to be computed. Possible choices are:
"symmetric", "asymmetricLower", "asymmetricUpper", "vertical", "horizontal".}

\item{...}{additional types of Separations to be computed. Possible choices are:
"symmetric", "asymmetricLower", "asymmetricUpper", "vertical", "horizontal".}
}
\value{
A list containing: 1) the required type of approximated separation matrices, according to the parameter \code{type} used
to build the \code{generator} (see function \code{BuildBubleyDyerSeparationGenerator}); 2) the number of generated linear extensions.
}
\description{
Computes exact separation matrices by evaluating the average separation over all the linear extensions of the input poset.
The linear extensions are generated according to the algorithm given in Habib M, Medina R, Nourine L and Steiner G (2001).
}
\details{
The symmetric separation associated to two elements \eqn{a} and \eqn{b} of the input poset, is the average
absolute difference between the positions of \eqn{a} and \eqn{b} observed over all linear extensions (whose elements are arranged in ascending order):

\eqn{Sep_{ab}=\frac{1}{n}\sum_{i^1}^{n}|Pos_{l_i}(a)-Pos_{l_i}(b)|},

where \eqn{n} is the numbers of linear extensions of the input poset;
\eqn{l_i} represents a single linear extension and \eqn{Pos_{l_i}(\cdot)} stands for the position of element \eqn{\cdot}
into the sequence of poset elements arranged in increasing order according to \eqn{l_i}.

Asymmetric lower and upper separations are defined as:
\eqn{Sep_{a < b}=\frac{1}{n}\sum_{i^1}^{n}(Pos_{l_i}(b)-Pos_{l_i}(a))\mathbb{1}(a <_{l_i} b)},
\eqn{Sep_{b < a}=\frac{1}{n}\sum_{i^1}^{n}(Pos_{l_i}(a)-Pos_{l_i}(b))\mathbb{1}(b <_{l_i} a)},
where \eqn{a\leq_{l_i} b} means that \eqn{a} is lower or equal to \eqn{b} in the linear order defined by linear
extension \eqn{l_i} and \eqn{\mathbb{1}} is the indicator function. Note that \eqn{Sep_{ab}=Sep_{a < b}+Sep_{a < b}}.

Vertical and horizontal separations (\eqn{vSep} and \eqn{hSep}, respectively) are defined as

\eqn{vSep_{ab}=|Sep_{a < b}-Sep_{b < a}|} and #' \eqn{hSep_{ab}=Sep_{ab}-vSep_{ab}|}.

For a detailed explanation on why \eqn{vSep} and \eqn{hSep} can be interpreted as vertical and horizontal components
of the separation between poset elements, see Fattore et. al (2024).
}
\examples{
el <- c("a", "b", "c", "d")

dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = el, dom = dom)

SEP_matrices <- ExactSeparation(pos, output_every_sec=5, "symmetric","asymmetricUpper", "vertical")

}
\references{
Habib M, Medina R, Nourine L and Steiner G (2001). Efficient algorithms on distributive lattices.
Discrete Applied Mathematics, 110, 169-187. https://doi.org/10.1016/S0166-218X(00)00258-4.

Fattore, M., De Capitani, L., Avellone, A., and Suardi, A. (2024).
A fuzzy posetic toolbox for multi-criteria evaluation on ordinal data systems.
Annals of Operations Research, https://doi.org/10.1007/s10479-024-06352-3.
}
