#ifndef genericFunctions_hpp
#define genericFunctions_hpp

#include <memory>
#include <list>
#include <vector>
#include <set>
#include <map>

namespace Generic {
    bool isReflexive(std::vector<std::string>&, std::map<std::string, std::set<std::string>>&);
    bool isSymmetric(std::list<std::pair<std::string, std::string>>&);
    bool isAntisymmetric(std::list<std::pair<std::string, std::string>>&);
    bool isTransitive(std::list<std::pair<std::string, std::string>>&);
    bool isPreorder(std::vector<std::string>&, std::map<std::string, std::set<std::string>>&);
    bool isPartialOrder(std::vector<std::string>&, std::map<std::string, std::set<std::string>>&);
    std::shared_ptr<std::list<std::pair<std::string, std::string>>> TransitiveClosure(std::list<std::pair<std::string, std::string>>&);
    std::shared_ptr<std::list<std::pair<std::string, std::string>>> ReflexiveClosure(std::vector<std::string>&, std::map<std::string, std::set<std::string>>&);
};

#endif /* genericFunctions_hpp */
