% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_distance.R
\name{get_distance}
\alias{get_distance}
\title{Distance between two distributions}
\usage{
get_distance(
  cov0,
  cov1,
  metric = c("ovl", "ksd", "astd", "std", "abd", "ley", "mhb", "omkss")
)
}
\arguments{
\item{cov0}{Vector (or matrix for \code{metric = "mhb"}) of samples from the
first distribution.}

\item{cov1}{Vector (or matrix for \code{metric = "mhb"}) of samples from the
second distribution.}

\item{metric}{Metric to use for calculating the distance with options:
\describe{
  \item{\code{ovl}}{Overlapping area} (default)
  \item{\code{ksd}}{Kullback-Leibler distance}
  \item{\code{astd}}{Standardized absolute mean difference}
  \item{\code{std}}{Standardized mean difference}
  \item{\code{abd}}{Absolute difference in means}
  \item{\code{ley}}{Levy distance}
  \item{\code{mhb}}{Mahalanobis distance}
  \item{\code{omkss}}{One minus Kolmogorov-Smirnov statistic}
}}
}
\value{
A real value of the distance.
}
\description{
Calculate difference measures using different metrics.
}
\examples{

x <- rnorm(100,  mean = 0, sd = 1)
y <- rnorm(1000, mean = 1, sd = 2)
get_distance(x, y, "ovl")
get_distance(x, y, "abd")

}
