% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mkReTrms}
\alias{mkReTrms}
\title{Design Matrices and Variance Components for Random Effects}
\usage{
mkReTrms(
  bars,
  fr,
  drop.unused.levels = TRUE,
  reorder.terms = FALSE,
  reorder.vars = FALSE
)
}
\arguments{
\item{bars}{a list of parsed random-effects terms}

\item{fr}{a model frame in which to evaluate these terms}

\item{drop.unused.levels}{(logical) drop unused factor levels?}

\item{reorder.terms}{arrange random effects terms in decreasing order of number of groups (factor levels)?}

\item{reorder.vars}{arrange columns of individual random effects terms in alphabetical order?}
}
\value{
A list with the following components:
\itemize{
\item Zt: Transposed random-effects design matrix.
\item G: Variance-covariance matrix for random effects.
\item Gind: Index mapping variance-covariance parameters to their positions in G.
\item G_temp: List of individual variance component matrices for each random effect.
\item flist: List of grouping factors used in random effects.
\item cnms: Column names of the random-effects design matrix.
\item Ztlist: List of per-term transposed design matrices for random effects.
\item nl: Number of levels for each grouping factor.
}
}
\description{
Adapted from lme4, this function constructs the design matrix (Z),
variance-covariance matrix (G), etc.
}
\keyword{internal}
