% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_calculation.R
\name{pwr.anova}
\alias{pwr.anova}
\title{Power of omnibus tests}
\usage{
pwr.anova(object, sig.level = 0.05, type = c("III", "II", "I", "3", "2", "1"))
}
\arguments{
\item{object}{a design object created in pwr4exp}

\item{sig.level}{significance level, default 0.05}

\item{type}{the type of ANOVA table requested, default Type III}
}
\value{
a data frame with numerator degrees of freedom (\code{NumDF}), denominator
degrees of freedom (\code{DenDF}), type I error rate (\code{sig.level}), and \code{power}.
}
\description{
Calculates the statistical power for testing the overall effects of treatment
factors and their interactions, i.e., power of F-test.
}
\examples{
# generate an RCBD
rcbd <- designRCBD(
  treatments = c(2, 2),
  label = list(facA = c("1", "2"), facB = c("1", "2")),
  blocks = 12,
  formula = ~ facA*facB + (1|block),
  means = c(32, 35, 30, 37),
  vcomp = 4,
  sigma2 = 6
)
# power of omnibus test
pwr.anova(rcbd)

}
\seealso{
\link{mkdesign}, \link{designCRD}, \link{designRCBD}, \link{designLSD}, \link{designCOD}, \link{designSPD}, \link{pwr.summary} and \link{pwr.contrast}
}
