ncross.rq.fitX <- function(y, X = NULL, taus, adjX.constr=TRUE, lambda.ridge = 0, eps = 1e-04, 
                           sparse=FALSE, nc.fit=FALSE, ...) {
#                           sgn.constr = 1, adjX.constr=TRUE, ...) {
  # Stima dei non-crossing rq con X lineari (la X dovrebbe avere una colonna di 1, se richiesta..) 
  #--------------------------------------------------------
      adj.middle = FALSE
      Rho <- function(u, tau) u * (tau - (u < 0))
      #-------------------------------------
      perm<-function (n=2, r, v = c(0,1)) {#gtools:permutation
        v <- unique(sort(v))
        v0 <- vector(mode(v), 0)
        sub <- function(n, r, v) {
          if (r == 1) 
            matrix(v, n, 1)
          else if (n == 1) 
            matrix(v, 1, r)
          else {
            inner <- Recall(n, r - 1, v)
            cbind(rep(v, rep(nrow(inner), n)), matrix(t(inner), 
                                                      ncol = ncol(inner), nrow = nrow(inner) * n, 
                                                      byrow = TRUE))
          }
        }
        sub(n, r, v[1:n])
      }
      #-------------------------------------
      # require(quantreg)
      # if (length(taus) <= 1) {
      #   o <- rq.fit(x = X, y = y, tau = taus, ...)
      #   o$rho <- sum(Rho(o$residuals[1:length(y)], taus))
      #   return(o)
      # }
      #browser()
      
      
      if(length(list(...))>0){
        if(sparse) {
          #maxiter=if("control"%in%names(list(...))) list(...)$control$maxiter else 200
          maxiter= list(...)$control$maxiter
          if(!is.numeric(maxiter)) stop(" 'maxiter' unspecified or non-numeric")
        } else {
          stop("Additional arguments in ... only if sparse=TRUE")
        }
      } else {
        maxiter<-if(sparse) sfn.control()$maxiter else 10^5
      }
      
      n <- length(y)
      taus <- sort(taus)
      
      colnamesB <- colnames(X)
      if(adjX.constr){
        if("(Intercept)" %in% colnamesB) {
          if(!ncol(X)>=2) stop("At leat one covariate")
          is.inter <- TRUE
          minX <- apply(X[,-1,drop=FALSE] ,2, min)
          names(minX)<-colnames(X)[-1]
          B<- cbind(X[,1], apply(X[,-1,drop=FALSE], 2, function(.x) .x- min(.x)))
        } else {
          if(!ncol(X)>=1) stop("At leat one covariate")
          is.inter <- FALSE
          minX <- apply(X ,2, min)
          names(minX)<-colnames(X)
          B<- apply(X, 2, function(.x) .x- min(.x))
        }
        p<-length(minX) #n. of covariates (regardless of the interc)
        all.max <- apply(B, 2, max)
      } else {
        B<- X
      }
      
      #colnames(B)<-colnamesB
      
      
      #a questo punto B e' sempre densa, quindi trasformala se sparse=TRUE
      if(sparse) B <- as.matrix.csr(B)
      
      if(lambda.ridge > 0) {
        if(sparse) {
          #B <- as.matrix.csr(X)
          Ip <- as(ncol(B), "matrix.diag.csr")
        } else {
          #B<-X
          Ip <- diag(ncol(B))
        }
        B <- rbind(B, lambda.ridge * Ip)
        y <- c(y, rep(0, nrow(Ip)))
      }

      rq.fit.fnb1<-function(x, y, tau, rhs) rq.fit.fnb(x,y,tau,rhs)
      rq.fit.fnc1<-function(x, y, tau, R, r, rhs) rq.fit.fnc(x,y,R,r,tau)
      
      if(sparse) {
        rqFit <- get("rq.fit.sfn", mode="function")
        rqFitC <- get("rq.fit.sfnc", mode="function")
        csB<- t(B)%*%rep(1,n) #colSums(B) pero' e' una colonna.. non funziona se e' sparse
        #B<-as.matrix.csr(B)
      } else {
        rqFit <- get("rq.fit.fnb1", mode="function")
        rqFitC <- get("rq.fit.fnc1", mode="function")
        csB<- colSums(B)
      }
      
      #browser()

      if (length(taus) <= 1) {
        #o.start <- if(sparse) rq.fit.sfn(B, y, tau = taus, ...) else rq.fit.fnb(B, y, tau = taus)
        o.start <- rqFit(B, y, taus, rhs=(1-taus)*csB, ...)
        if(isTRUE(all.equal(o.start$it, maxiter+1))) warning(paste("max iter attained at tau", taus), call. = FALSE)
        

        all.COEF <- o.start$coef
        # colnames(all.COEF)<-paste(taus)
        all.df <- sum(round(o.start$residuals[1:n], 2) == 0)
        all.rho <- sum(Rho(o.start$residuals[1:n], taus))
        r <- list(coefficients = all.COEF, B = B, df = all.df, rho = all.rho, 
                  fitted.values = o.start$fitted.values[1:n], residuals = o.start$residuals[1:n])
      } else {  # se length(taus)>1
        
        id.start.tau <- which.min(abs(taus - 0.5))
        start.tau <- taus[id.start.tau]
      
        pos.taus <- taus[(taus - start.tau) > 0]
        neg.taus <- taus[(taus - start.tau) < 0]
        n.pos.taus <- length(pos.taus)
        n.neg.taus <- length(neg.taus)
      
        #browser()
        DF.NEG <- DF.POS<- NULL
        #Ident <- diag(p)

        #o.start <- if(sparse) rq.fit.sfn(B, y, tau = start.tau, ...) else rq.fit( B,  y, tau = start.tau)        
        o.start <- rqFit(B, y, tau = start.tau, rhs=(1-start.tau)*csB, ...)
        
        #browser()
        
        if(isTRUE(all.equal(o.start$it, maxiter+1))) warning(paste("max iter attained at tau", start.tau), call. = FALSE)

        COEF.POS <- COEF.NEG <- FIT.POS <- FIT.NEG <- RES.POS <- RES.NEG <- NULL
        df.pos.tau <- df.neg.tau <- rho.pos.tau <- rho.neg.tau <- NULL

        #browser()
        #build the constraint matrix
        if(!nc.fit){
          a<-perm(2, p, c(0,1))
          a<-a[order(rowSums(a)),,drop=FALSE]
          if(is.inter){
            a<- a * matrix(all.max[-1], nrow=nrow(a), ncol=p, byrow = TRUE)
            RR<-cbind(1,a)
          } else {
            a<-a[-1,]
            RR<-a * matrix(all.max, nrow=nrow(a), ncol=p, byrow = TRUE)
          }
        } else {
          RR<-B
        }
        
        if(sparse) RR <- as.matrix.csr(RR)
        
#as(p, "matrix.diag.csr") else diag(p) 
        
        #-----------------------------------------
        if (n.pos.taus > 0) {
          rho.pos.tau <- df.pos.tau <- vector(length = n.pos.taus)
          COEF.POS <- matrix(, ncol(B), n.pos.taus)
          colnames(COEF.POS) <- paste(pos.taus)
          b.start <- o.start$coef

          rr<-RR%*%b.start + eps

          # DF per NONcrossing
          DF.POS <- matrix(,nrow(RR),n.pos.taus)
          colnames(DF.POS) <- paste(pos.taus)

          FIT.POS <- RES.POS <- matrix(, n, n.pos.taus)
          #browser()
          
          nn=n
          for(i in 1:n.pos.taus){
            #if(i==3) browser()
            
            o <- rqFit(B, y, tau = pos.taus[i], rhs=(1-pos.taus[i])*csB, ...)
            id<-drop(RR%*%o$coefficients<rr)
            #oppure - per essere piu' conservativi (cioe' per evitare che 
            #riducendo troppo il numero dei vincoli poi alla fine non funzioni) si potrebbe
            #id<-drop(RR%*%o$coefficients<rr+tol) #dove tol=median(rr)/100 oppuure un 0.05
            if(any(id)) {
              id<-drop(RR%*%o$coefficients<rr+.001)
              if(nrow(RR[id,,drop=FALSE])>nn) {
                cat("# of constraints > n. Use 'nc.fit=TRUE'?")
                readline(prompt=".. if no, press [enter] to continue or [esc]")
                nn=10^12
              }
              o <- rqFitC(B, y, tau = pos.taus[i], R=RR[id,,drop=FALSE], r=rr[id], rhs=(1-pos.taus[i])*csB, ...)
            }
            id<-drop(RR%*%o$coefficients<rr)
            if(any(id)) o <- rqFitC(B, y, tau = pos.taus[i], R=RR, r=rr, rhs=(1-pos.taus[i])*csB, ...)
            
            if(isTRUE(all.equal(o$it,maxiter+1))) warning(paste("max iter attained at tau", pos.taus[i]), call. = FALSE)
            
            #if(any(id)) o <- rqFitC(B, y, tau = pos.taus[i], R=RR, r=rr,...)
            #o <- rq.fit(x = B, y = y, tau = pos.taus[i], method = "fnc", R = RR, r = rr)

            FIT.POS[, i] <- y[1:n] - o$residuals[1:n]# o$fitted.values[1:n]
            RES.POS[, i] <- o$residuals[1:n]
            # estrai la f. obiettivo
            df.pos.tau[i] <- sum(abs(o$residuals[1:n]) <= 1e-06)  #length(o$coef)
            rho.pos.tau[i] <- sum(Rho(o$residuals[1:n], pos.taus[i]))
            b.start <- o$coef
            COEF.POS[, i] <- b.start
            DF.POS[,i] <- 1*(drop(RR%*%b.start-rr)<=1e-8)
            rr<-RR%*%b.start + eps
          }  #end for
        }#end if(n.pos.taus>0)
        #-----------------------------------------------------------------
        #browser()
        
        if (n.neg.taus > 0) {
          rho.neg.tau <- df.neg.tau <- vector(length = n.pos.taus)
          COEF.NEG <- matrix(, ncol(B), n.neg.taus)
          colnames(COEF.NEG) <- paste(neg.taus)
          b.start <- o.start$coef
          neg.taus <- sort(neg.taus, TRUE)
          
          RR <- -RR
          rr <- RR%*%b.start + eps

          #DF per NONcrossing
          DF.NEG<- matrix(,nrow(RR),n.neg.taus)
          colnames(DF.NEG)<-paste(neg.taus)
          FIT.NEG <- RES.NEG <- matrix(, n, n.neg.taus)
          
          #browser()
          nn=n
          for (i in 1:n.neg.taus) {
            o <- rqFit(B, y, tau = neg.taus[i], rhs=(1-neg.taus[i])*csB, ...)
            #browser()
            
            id<-drop(RR%*%o$coefficients<rr) #rr+mean(abs(rr))/10
            if(any(id)) {
              id<-drop(RR%*%o$coefficients<rr+.001)
              if(nrow(RR[id,,drop=FALSE])>nn) {
                cat("# of constraints > n. Use 'nc.fit=TRUE'?")
                readline(prompt=".. if no, press [enter] to continue or [esc]")
                nn=10^12
              }
              
              o <- rqFitC(B, y, tau = neg.taus[i], R=RR[id,,drop=FALSE], r=rr[id], rhs=(1-neg.taus[i])*csB, ...)
            }
            id<- drop(RR%*%o$coefficients<rr)
            if(any(id)) o <- rqFitC(B, y, tau = neg.taus[i], R=RR, r=rr, rhs=(1-neg.taus[i])*csB, ...)
            #browser()
            
            if(isTRUE(all.equal(o$it,maxiter+1))) warning(paste("max iter attained at tau", neg.taus[i]), call. = FALSE)
            #o <- rqFit(B, y, tau = neg.taus[i], R=RR, r=rr, ...) 
            
            
            #o <- rq.fit(x = B, y = y, tau = neg.taus[i], method = "fnc", 
             #           R = RR, r = rr)
            FIT.NEG[, i] <- y[1:n] - o$residuals[1:n] #o$fitted.values[1:n]
            RES.NEG[, i] <- o$residuals[1:n]
            df.neg.tau[i] <- sum(abs(o$residuals[1:n]) <= 1e-06)  #length(o$coef)
            rho.neg.tau[i] <- sum(Rho(o$residuals[1:n], neg.taus[i]))
            b.start <- o$coef
            COEF.NEG[, i] <- b.start
            DF.NEG[,i] <- 1*(drop(RR%*%b.start-rr)<=1e-8)
            
            rr<- RR%*%b.start + eps
            
          }  #end for
        }  #end if(n.neg.taus>0)
        #------------------------------
        #browser()
        monotone <- FALSE
        R = NULL
        # if (adj.middle) {
        #   if (monotone) {
        #     RR <- rbind(Ident, -Ident, R)
        #     rr <- c(COEF.NEG[, 1], -COEF.POS[, 1], rep(0, p - 1))
        #   } else {
        #     RR <- rbind(Ident, -Ident)
        #     rr <- c(COEF.NEG[, 1], -COEF.POS[, 1])
        #   }
        #   o.start <- rq.fit(x = B, y = y, tau = start.tau, method = "fnc", 
        #                     R = RR, r = rr)
        # }
        #-------------------------------
        all.COEF <- cbind(COEF.NEG[, n.neg.taus:1, drop = FALSE], o.start$coef, 
                          COEF.POS)
        colnames(all.COEF) <- paste(taus)
        rownames(all.COEF) <- colnames(X)
        all.FIT <- cbind(FIT.NEG[, n.neg.taus:1, drop = FALSE], y[1:n]-o.start$residuals[1:n], 
                         FIT.POS)
        colnames(all.FIT) <- paste(taus)
        all.RES <- cbind(RES.NEG[, n.neg.taus:1, drop = FALSE], o.start$residuals[1:n], 
                         RES.POS)
        colnames(all.RES) <- paste(taus)
        all.df <- c(df.neg.tau[n.neg.taus:1], sum(abs(o.start$residuals[1:n]) <= 1e-06), df.pos.tau)
        all.rho <- c(rho.neg.tau[n.neg.taus:1], sum(Rho(o.start$residuals[1:n], start.tau)), rho.pos.tau)
        r <- list(coefficients = all.COEF, x = X, df = all.df, rho = all.rho, 
                  fitted.values = all.FIT, residuals = all.RES, DF.NEG=DF.NEG, DF.POS=DF.POS, minX=minX)
      }
      id.coef <- 1:ncol(X)
      attr(id.coef, "nomi") <- colnames(X)
      r$id.coef <- id.coef
      return(r)
}
