% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{insert_model}
\alias{insert_model}
\title{Insert a model into apsimx}
\usage{
insert_model(l, path, model)
}
\arguments{
\item{l}{the list of apsimx file}

\item{path}{If numeric, the path returned by search_path or search_node. If character, the path supported by apsimx}

\item{model}{A new model}
}
\value{
The modified list with new value
}
\description{
Insert a model into apsimx
}
\examples{
wheat <- read_apsimx(system.file("extdata/wheat.apsimx", package = "rapsimng"))
replacements <- new_model("Core.Replacements")
wheat_new <- insert_model(wheat, 1, replacements)
replacements_node <- search_path(wheat_new, ".Simulations.Replacements")
replacements_node$path
# Add a cultivar folder under replacements
cultivar_folder <- new_model("PMF.CultivarFolder", "Cultivars")
wheat_new <- insert_model(wheat_new, replacements_node$path, cultivar_folder)
cultivar_folder_node <- search_path(wheat_new,
                                    ".Simulations.Replacements.Cultivars")
cultivar_folder_node$path
# Add an new cultivar
cultivar <- new_model("PMF.Cultivar", "Hartog")
wheat_new <- insert_model(wheat_new, cultivar_folder_node$path, cultivar)
cultivar_node <- search_path(wheat_new,
                             ".Simulations.Replacements.Cultivars.Hartog")
cultivar_node$path
}
