% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class002-project.R
\name{as_rave_project}
\alias{as_rave_project}
\alias{as_rave_project.character}
\title{Convert character to \code{\link{RAVEProject}} instance}
\usage{
as_rave_project(x, ...)

\method{as_rave_project}{character}(x, strict = TRUE, parent_path = NULL, ...)
}
\arguments{
\item{x}{R object that can be converted to 'RAVE' project. When \code{x}
is a character, see 'Details' on the rules.}

\item{...}{passed to other methods, typically includes \code{strict} on
whether to check existence of the project folder, and \code{parent_path},
specifying non-default project root}

\item{strict}{whether to check project path; if set to true and the project
path is missing, the program will raise warnings}

\item{parent_path}{parent path in which the project is non-default, can be
a path to the parent folder of the project, or a
\code{\link[bidsr]{bids_project}} object. When the subject is from 'BIDS',
the \code{parent_path} must be the root of 'BIDS' directory.}
}
\value{
A \code{\link{RAVEProject}} instance
}
\description{
Convert character to \code{\link{RAVEProject}} instance
}
\details{
A 'RAVE' project is an aggregation of subjects with the similar research
targets. For example, 'RAVE' comes with a demo subject set, and the project
'demo' contains eight subjects undergoing same experiments. Project
\code{'YAEL'} contains subject whose electrodes are localized by
\code{'YAEL'} modules.
The project can be "arbitrary": this is different to a 'BIDS' "project",
often served as a data-set name or identifier. A 'BIDS' project may have
multiple 'RAVE' projects. For example, an audio-visual 'BIDS' data may have
a 'RAVE' project \code{'McGurk'} to study the \code{'McGurk'} effect and
another \code{'synchrony'} to study the audio-visual synchronization.

A valid 'RAVE' project name must only contain letters and digits;
underscores and dashes may be acceptable but might subject to future change.
For example \code{'demo'} is a valid project name, but \code{'my demo'} is
invalid.

RAVE supports storing the data in \code{'native'} or \code{'bids'}-compliant
formats. The native format is compatible with the 'RAVE' 1.0 and 2.0, and
requires no conversion to 'BIDS' format, while \code{'bids'} requires the
data to be stored and processed in 'BIDS'-complaint format, which is better
for data sharing and migration, but might be over-kill in some cases.

If the project string contains \code{'@'}, the characters after the 'at'
sign will be interpreted as indication of the storage format. For instance
\code{'demo@native'} or \code{'demo@bids:ds0001'} are interpreted
differently. The previous one indicates that the project \code{'demo'} is
stored with native format, usually located at \code{'rave_data/data_dir'}
under the home directory (can be manually set to other locations). The
latter one means the 'RAVE' project \code{'demo'} is stored under 'BIDS'
folder with a 'BIDS' data-set name \code{'ds0001'}.
}
\examples{


# ---- Native format (RAVE legacy) ------------------------
project <- as_rave_project("demo", strict = FALSE)

format(project)

project$path

project$subjects()

# Non-standard project locations (native format)
as_rave_project("demo", strict = FALSE,
                parent_path = "~/Downloads")


# ---- BIDS format ----------------------------------------
project <- as_rave_project("demo@bids:ds001", strict = FALSE)

format(project)

project$path

# BIDS format, given the parent folder; this example requires
# 'bidsr' sample data. Run `bidsr::download_bids_examples()` first.

examples <- bidsr::download_bids_examples(test = TRUE)

if(!isFALSE(examples)) {

  project <- as_rave_project(
    "audiovisual@bids", strict = FALSE,
    parent_path = file.path(examples, "ieeg_epilepsy_ecog"))

  # RAVE processed data is under BIDS dirivative folder
  project$path

  # "audiovisual@bids:ieeg_epilepsy_ecog"
  format(project)
}



}
\seealso{
\code{\link{RAVEProject}}
}
