% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-ymonpctl.R, R/op-cdo-ymonpctl.R
\name{ymonpctl}
\alias{ymonpctl}
\alias{cdo_ymonpctl}
\title{Multiyear monthly percentile values}
\usage{
cdo_ymonpctl(ifile1, ifile2, ifile3, p = NULL, ofile = NULL)
}
\arguments{
\item{ifile1, ifile2, ifile3}{Strings with the path to the input files.}

\item{p}{FLOAT - Percentile number in \{0, ..., 100\}}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
This operator writes a certain percentile of each month of year in infile1 to outfile. The algorithm uses histograms with minimum and maximum bounds given in infile2 and infile3, respectively. The default number of histogram bins is 101. The default can be overridden by setting the environment variable CDO_PCTL_NBINS to a different value. The files infile2 and infile3 should be the result of corresponding ymonmin and ymonmax operations, respectively. The date information in an output field is the date of the last contributing input field.  o(01,x) = pth percentile \{i(t,x), month(i(t)) = 01\} ... o(12,x) = pth percentile \{i(t,x), month(i(t)) = 12\}
}
