% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohenW.r
\name{cohenW}
\alias{cohenW}
\title{Cohen's w (omega)}
\usage{
cohenW(
  x,
  y = NULL,
  p = NULL,
  ci = FALSE,
  conf = 0.95,
  type = "perc",
  R = 1000,
  histogram = FALSE,
  digits = 4,
  reportIncomplete = FALSE,
  ...
)
}
\arguments{
\item{x}{Either a two-way table or a two-way matrix.
Can also be a vector of observations for one dimension
of a two-way table.}

\item{y}{If \code{x} is a vector, \code{y} is the vector of observations for
the second dimension of a two-way table.}

\item{p}{If \code{x} is a vector of observed counts, \code{p} can be given as
a vector of theoretical probabilties,
as in a chi-square goodness of fit test.}

\item{ci}{If \code{TRUE}, returns confidence intervals by bootstrap.
May be slow.}

\item{conf}{The level for the confidence interval.}

\item{type}{The type of confidence interval to use.
Can be any of "\code{norm}", "\code{basic}", 
              "\code{perc}", or "\code{bca}".
Passed to \code{boot.ci}.}

\item{R}{The number of replications to use for bootstrap.}

\item{histogram}{If \code{TRUE}, produces a histogram of bootstrapped values.}

\item{digits}{The number of significant digits in the output.}

\item{reportIncomplete}{If \code{FALSE} (the default),
\code{NA} will be reported in cases where there
are instances of the calculation of the statistic
failing during the bootstrap procedure.
In the case of the goodness-of-fit
scenario, setting this to \code{TRUE}
will have no effect.}

\item{...}{Additional arguments passed to \code{chisq.test}.}
}
\value{
A single statistic, Cohen's w.
        Or a small data frame consisting of Cohen's w,
        and the lower and upper confidence limits.
}
\description{
Calculates Cohen's w for a table of nominal variables.
}
\details{
Cohen's w is used as a measure of association
          between two nominal variables, or as an effect size
          for a chi-square test of association.  For a 2 x 2 table,
          the absolute value of the phi statistic is the same as
          Cohen's w.  
          The value of Cohen's w is not bound by 1 on the upper end.

          Cohen's w is "naturally nondirectional". That is,
          the value will always be zero or positive.
          Because of this, if \code{type="perc"},
          the confidence interval will
          never cross zero.
          The confidence interval range should not
          be used for statistical inference.
          However, if \code{type="norm"}, the confidence interval
          may cross zero.  
          
          When w is close to 0 or very large,
          or with small counts, 
          the confidence intervals 
          determined by this
          method may not be reliable, or the procedure may fail.
}
\examples{
### Example with table
data(Anderson)
fisher.test(Anderson)
cohenW(Anderson)

### Example for goodness-of-fit
### Bird foraging example, Handbook of Biological Statistics
observed = c(70,   79,   3,    4)
expected = c(0.54, 0.40, 0.05, 0.01)
chisq.test(observed, p = expected)
cohenW(observed, p = expected)

### Example with two vectors
Species = c(rep("Species1", 16), rep("Species2", 16))
Color   = c(rep(c("blue", "blue", "blue", "green"),4),
            rep(c("green", "green", "green", "blue"),4))
fisher.test(Species, Color)
cohenW(Species, Color)

}
\references{
\url{https://rcompanion.org/handbook/H_10.html}

Cohen J. 1992. "A Power Primer". Psychological Bulletin 12(1): 155-159.

Cohen, J. 1988. Statistical Power Analysis for the Behavioral Sciences, 2nd Ed. Routledge.
}
\seealso{
\code{\link{cramerV}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{Cohen's w}
\concept{chi square test}
\concept{confidence interval}
\concept{effect size}
\concept{omega}
