% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseModelAnova.r
\name{pairwiseModelAnova}
\alias{pairwiseModelAnova}
\title{Compare model objects with F test and likelihood ratio test}
\usage{
pairwiseModelAnova(fits, ...)
}
\arguments{
\item{fits}{A series of model object names, separated by commas.}

\item{...}{Other arguments passed to \code{list}.}
}
\value{
A list of: The calls of the models compared; a data frame of 
        comparisons and F tests; and a data frame of
        comparisons and likelihood ratio tests.
}
\description{
Compares a series of models with pairwise F tests and
             likelihood ratio tests.
}
\details{
For comparisons to be valid, both models must
          have the same data, without transformations, use the same 
          dependent variable, and be fit with the same method.
          
          To be valid, models need to be nested.
}
\examples{
### Compare among polynomial models
data(BrendonSmall)
BrendonSmall$Calories = as.numeric(BrendonSmall$Calories)

BrendonSmall$Calories2 = BrendonSmall$Calories * BrendonSmall$Calories
BrendonSmall$Calories3 = BrendonSmall$Calories * BrendonSmall$Calories * 
                         BrendonSmall$Calories
BrendonSmall$Calories4 = BrendonSmall$Calories * BrendonSmall$Calories * 
                         BrendonSmall$Calories * BrendonSmall$Calories
model.1 = lm(Sodium ~ Calories, data = BrendonSmall)
model.2 = lm(Sodium ~ Calories + Calories2, data = BrendonSmall)
model.3 = lm(Sodium ~ Calories + Calories2 + Calories3, data = BrendonSmall)
model.4 = lm(Sodium ~ Calories + Calories2 + Calories3 + Calories4,
             data = BrendonSmall)
pairwiseModelAnova(model.1, model.2, model.3, model.4)

}
\seealso{
\code{\link{compareGLM}}, \code{\link{compareLM}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{F test}
\concept{likelihood ratio test}
