% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recolorize_to_patternize.R
\name{recolorize_to_patternize}
\alias{recolorize_to_patternize}
\title{Convert a recolorize object to a raster object}
\usage{
recolorize_to_patternize(recolorize_obj, return_background = FALSE)
}
\arguments{
\item{recolorize_obj}{A \code{recolorize} object.}

\item{return_background}{Logical.}
}
\value{
A list of RasterLayer objects, one per color class.
}
\description{
Convert from a \code{recolorize} object to a list of RasterLayer objects, the
format required by the \code{patternize} package. Note that most of the downstream
\code{patternize} functions that require lists of RasterLayer objects mostly
require lists of these lists, so you will probably need to use this function
on a list of \code{recolorize} objects.
}
\details{
Note that this function does not retain the colors of the layers --
you won't be able to convert back to a recolorize object from this object.
}
\examples{

\donttest{
# fit recolorize object:
img <- system.file("extdata/ephippigera.png", package = "recolorize")
rc <- recolorize2(img)

# takes ~10 sec to run:
# convert to a raster list:
as_raster_list <- recolorize_to_patternize(rc)
}

}
