% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{nh_map}
\alias{nh_map}
\title{New Hampshire Election and Demographic Data as a \code{redist_map}}
\format{
A redist_map with 326 rows and 45 columns
\itemize{
\item GEOID20: 2020 VTD GEOID
\item state: state name
\item county: county name
\item vtd: VTD portion of GEOID
\item pop: total population
\item pop_hisp: Hispanic population
\item pop_white: White, not Hispanic population
\item pop_black: Black, not Hispanic population
\item pop_aian: American Indian and Alaska Native, not Hispanic population
\item pop_asian: Asian, not Hispanic population
\item pop_nhpi: Native Hawaiian and Pacific Islander, not Hispanic population
\item pop_other: other race, not Hispanic population
\item pop_two: multi-race, not Hispanic population
\item vap: total voting-age population
\item vap_hisp: Hispanic voting-age population
\item vap_white: White, not Hispanic voting-age population
\item vap_black: Black, not Hispanic voting-age population
\item vap_aian: American Indian and Alaska Native, not Hispanic voting-age population
\item vap_asian: Asian, not Hispanic voting-age population
\item vap_nhpi: Native Hawaiian and Pacific Islander, not Hispanic voting-age population
\item vap_other: other race, not Hispanic voting-age population
\item vap_two: multi-race, not Hispanic voting-age population
\item pre_16_rep_tru: Votes for Republican president 2016
\item pre_16_dem_cli: Votes for Democratic president 2016
\item uss_16_rep_ayo: Votes for Republican senate 2016
\item uss_16_dem_has: Votes for Democratic senate 2016
\item gov_16_rep_sun: Votes for Republican governor 2016
\item gov_16_dem_van: Votes for Democratic governor 2016
\item gov_18_rep_sun: Votes for Republican governor 2018
\item gov_18_dem_kel: Votes for Democratic governor 2018
\item pre_20_dem_bid: Votes for Democratic president 2020
\item pre_20_rep_tru: Votes for Republican president 2020
\item uss_20_dem_sha: Votes for Democratic senate 2020
\item uss_20_rep_mes: Votes for Republican senate 2020
\item gov_20_dem_fel: Votes for Democratic governor 2020
\item gov_20_rep_sun: Votes for Republican governor 2020
\item arv_16: Average Republican vote 2016
\item adv_16: Average Democratic vote 2016
\item arv_18: Average Republican vote 2018
\item adv_18: Average Democratic vote 2018
\item arv_20: Average Republican vote 2020
\item adv_20: Average Democratic vote 2020
\item nrv: Normal Republican vote
\item ndv: Normal Democratic vote
\item r_2020: Republican proposed plan for 2020 Congressional districts
\item d_2020: Democratic proposed plan for 2020 Congressional districts
\item adj: zero-indexed adjacency graph
\item geometry: sf geometry, simplified for size using rmapshaper
}
}
\usage{
data("nh_map")
}
\description{
This data set contains demographic, election, and geographic information for
the 326 voting tabulation districts in New Hampshire in 2020.
}
\examples{
data(nh_map)
}
\references{
Voting and Election Science Team, 2020, "2020 Precinct-Level Election Results",
https://doi.org/10.7910/DVN/K7760H, Harvard Dataverse, V23

Voting and Election Science Team, 2018, "2016 Precinct-Level Election Results",
https://doi.org/10.7910/DVN/NH5S2I, Harvard Dataverse, V71

Voting and Election Science Team, 2019, "2018 Precinct-Level Election Results",
https://doi.org/10.7910/DVN/UBKYRU, Harvard Dataverse, V48

Kenny & McCartan (2021, Aug. 10). ALARM Project: 2020 Redistricting Data Files.
Retrieved from \url{https://github.com/alarm-redist/census-2020/}
}
\concept{data}
