% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partisan.R
\name{part_dislocation}
\alias{part_dislocation}
\title{Calculate Partisan Dislocation}
\usage{
part_dislocation(
  plans,
  shp,
  dvote,
  rvote,
  total_pop = dvote + rvote,
  epsg = 3857,
  by_precinct = FALSE,
  signed = TRUE
)
}
\arguments{
\item{plans}{A \code{redist_plans} object or plans_matrix where each row indicates a district assignment and each column is a plan.}

\item{shp}{A \code{redist_map} object, tibble, or data frame with an \code{sf} geometry column.}

\item{dvote}{Unqouted name of column in \code{shp} with total population.}

\item{rvote}{Unqouted name of column in \code{shp} with group population.}

\item{total_pop}{Unqouted name of column in \code{shp} with total population.}

\item{epsg}{Numeric EPSG code to use to project the shapefile, if needed. Default is 3857.}

\item{by_precinct}{Defaults to \code{FALSE}, returning district-level values.}

\item{signed}{Defaults to \code{TRUE}. Should the output for district-level values be signed?
Setting to \code{TRUE} returns precinct-level values.}
}
\value{
A numeric vector. Can be shaped into a district-by-plan matrix.
}
\description{
Calculate Partisan Dislocation
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
part_dislocation(plans = nh$r_2020, shp = nh, rvote = nrv, dvote = ndv)

# Or many plans:
part_dislocation(plans = nh_m[, 3:5], shp = nh, rvote = nrv, dvote = ndv)

}
\references{
DeFord, D. R., Eubank, N., & Rodden, J. (2022). Partisan dislocation: A
precinct-level measure of representation and gerrymandering. Political
Analysis, 30(3), 403-425.
}
\concept{partisan}
