% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bars.R
\name{cluster_bar}
\alias{cluster_bar}
\title{Cluster-level Bar Plot of Enrichment Significance}
\usage{
cluster_bar(cluster_result, clusters = NULL, value_type = "Padj", title = NULL)
}
\arguments{
\item{cluster_result}{A result list returned by \code{\link{cluster}}.}

\item{clusters}{Optional numeric vector of cluster IDs to include. Defaults to all clusters.}

\item{value_type}{The column name to use for enrichment significance ("Padj" or "Pvalue").}

\item{title}{Optional plot title. If NULL, a default will be generated.}
}
\value{
A \code{plotly} object representing the bar plot.
}
\description{
Generates a horizontal bar plot showing average enrichment significance
for each cluster, across one or more enrichment datasets.
}
\examples{
\donttest{
# Load example data
cluster_result <- readRDS(system.file("extdata", "cluster_result.rds",
                                      package = "richCluster"))
cbar <- cluster_bar(cluster_result)
cbar
}
}
