% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/david_cluster.R
\name{david_cluster}
\alias{david_cluster}
\title{Cluster Terms using DAVID's method}
\usage{
david_cluster(
  enrichment_results,
  df_names = NULL,
  similarity_threshold = 0.5,
  initial_group_membership = 3,
  final_group_membership = 3,
  multiple_linkage_threshold = 0.5
)
}
\arguments{
\item{enrichment_results}{A list of dataframes, each containing enrichment results.
Each dataframe should include at least the columns 'Term', 'GeneID', and 'Padj'.}

\item{df_names}{Optional, a character vector of names for the enrichment result dataframes. Must
match the length of `enrichment_results`. Default is `NULL`.}

\item{similarity_threshold}{A numeric value for the kappa score cutoff (0 < cutoff <= 1).}

\item{initial_group_membership}{Minimum number of terms to form an initial seed group.}

\item{final_group_membership}{Minimum number of terms for a final cluster.}

\item{multiple_linkage_threshold}{A numeric value for the merging threshold.}
}
\value{
A named list containing the clustering results.
}
\description{
This function performs clustering on enrichment results using an algorithm
inspired by DAVID's functional clustering method.
}
