% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreci.R
\name{scoreci}
\alias{scoreci}
\title{Wilson Score Confidence Intervals}
\usage{
scoreci(success, total, level = 0.95, return_midpoint = FALSE)
}
\arguments{
\item{success}{Success count.}

\item{total}{Total count.}

\item{level}{Optional. Confidence level. Defaults to 0.95.}

\item{return_midpoint}{Optional. Return midpoint of confidence
interval? Defaults to \code{FALSE}.}
}
\value{
Data frame:
\itemize{
\item \code{success} Success count
\item \code{total} Total count
\item \code{estimate} Proportion
\item \code{conf.low} Lower bound of the confidence interval.
\item \code{conf.high} Upper bound of the confidence interval.
\item \code{midpoint} Mid-point of the confidence interval
(for \code{return_midpoint = TRUE}).
\item \code{level} Confidence level.
}
}
\description{
"This function computes a confidence interval for a proportion.
It is based on inverting the large-sample normal score test for the
proportion." (Alan Agresti, who wrote the original R code)

Inputs for \code{success}, \code{total}, and \code{level}
are vectorized.
}
\examples{
scoreci(success = 5, total = 10)
scoreci(success = c(5:10), total = 10, level = 0.9)
}
\seealso{
\url{https://users.stat.ufl.edu/~aa/cda/R/one-sample/R1/index.html}

Agresti A, Coull BA. Approximate is better than "exact" for
interval estimation of binomial proportions. Am Stat 1998;52:119-126.
\doi{10.2307/2685469}

Brown LD, Cai TT, DasGupta A. Interval estimation for a
binomial proportion (with discussion). Stat Sci 2001;16:101-133.
\doi{10.1214/ss/1009213286}
}
