/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.akf;

import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.data.DataBlockStorage;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.GeneralMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixStorage;
import jdplus.toolkit.base.core.math.matrices.MatrixTransformation;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.akf.AugmentedFilter;
import jdplus.toolkit.base.core.ssf.akf.AugmentedState;
import jdplus.toolkit.base.core.ssf.akf.DefaultQFilteringResults;
import jdplus.toolkit.base.core.ssf.akf.QAugmentation;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;

public class SmoothationsComputer {
    private AugmentedState state;
    private ISsfDynamics dynamics;
    private ISsfLoading loading;
    private DataBlockStorage allR;
    private MatrixStorage allRvar;
    private DefaultQFilteringResults frslts;
    private double err;
    private double errVariance;
    private double u;
    private DataBlock M;
    private DataBlock K;
    private DataBlock E;
    private DataBlock U;
    private DataBlock R;
    private DataBlock Rc;
    private FastMatrix N;
    private FastMatrix Nc;
    private FastMatrix Rd;
    private FastMatrix S;
    private DataBlock delta;
    private boolean missing;
    private boolean hasinfo;

    public boolean process(ISsf ssf, ISsfData data) {
        int n = data.length();
        this.frslts = DefaultQFilteringResults.light();
        this.frslts.prepare(ssf, 0, n);
        AugmentedFilter filter = new AugmentedFilter(false);
        filter.process(ssf, data, this.frslts);
        this.initFilter(ssf);
        int dim = ssf.getStateDim();
        this.allR = new DataBlockStorage(dim, n);
        this.allRvar = new MatrixStorage(dim, dim, n);
        this.initSmoother(ssf);
        while (--n >= 0) {
            this.iterate(n);
            if (!this.hasinfo) continue;
            this.allR.save(n, this.Rc);
            this.allRvar.save(n, this.Nc);
        }
        return true;
    }

    private void initSmoother(ISsf ssf) {
        ISsfInitialization initialization = ssf.initialization();
        int dim = initialization.getStateDim();
        int nd = initialization.getDiffuseDim();
        this.state = new AugmentedState(dim, nd);
        this.R = DataBlock.make(dim);
        this.Rc = DataBlock.make(dim);
        this.M = DataBlock.make(dim);
        this.K = DataBlock.make(dim);
        this.E = DataBlock.make(nd);
        this.U = DataBlock.make(nd);
        this.Rd = FastMatrix.make(dim, nd);
        this.N = FastMatrix.square(dim);
        this.Nc = FastMatrix.square(dim);
        QAugmentation q = this.frslts.getAugmentation();
        this.S = q.a().deepClone();
        this.delta = q.b().deepClone();
        LowerTriangularMatrix.solvexL(this.S, this.delta);
        this.delta.chs();
    }

    private void loadInfo(int pos) {
        DataBlock fa;
        this.err = this.frslts.error(pos);
        this.errVariance = this.frslts.errorVariance(pos);
        this.missing = !Double.isFinite(this.err);
        this.E.copy(this.frslts.E(pos));
        this.M.copy(this.frslts.M(pos));
        if (this.errVariance != 0.0) {
            this.K.copy(this.frslts.M(pos));
            this.dynamics.TX(pos, this.K);
            this.K.div(this.errVariance);
        }
        boolean bl = this.hasinfo = (fa = this.frslts.a(pos)) != null;
        if (!this.hasinfo) {
            return;
        }
        this.state.a().copy(fa);
    }

    private void iterate(int pos) {
        this.loadInfo(pos);
        this.iterateSmoothation(pos);
        this.iterateR(pos);
        this.iterateN(pos);
    }

    private void xL(int pos, DataBlock x) {
        this.dynamics.XT(pos, x);
        double q = x.dot(this.M);
        this.loading.XpZd(pos, x, -q / this.errVariance);
    }

    private void XL(int pos, DataBlockIterator X) {
        while (X.hasNext()) {
            this.xL(pos, X.next());
        }
    }

    private void iterateN(int pos) {
        if (!this.missing) {
            this.XL(pos, this.N.rowsIterator());
            this.XL(pos, this.N.columnsIterator());
            this.loading.VpZdZ(pos, this.N, 1.0 / this.errVariance);
        } else {
            this.dynamics.MT(pos, this.N);
            this.dynamics.TtM(pos, this.N);
        }
        SymmetricMatrix.reenforceSymmetry(this.N);
        this.N.apply(z -> Math.abs(z) < 1.0E-9 ? 0.0 : z);
        FastMatrix W = this.Rd.deepClone();
        LowerTriangularMatrix.solveXLt(this.S, W);
        this.Nc.copy(this.N);
        GeneralMatrix.aAB_p_bC(-1.0, W, W, 1.0, this.Nc, MatrixTransformation.None, MatrixTransformation.Transpose);
        SymmetricMatrix.reenforceSymmetry(this.Nc);
        this.Nc.apply(z -> Math.abs(z) < 1.0E-9 ? 0.0 : z);
    }

    private void iterateR(int pos) {
        this.dynamics.XT(pos, this.R);
        this.dynamics.TtM(pos, this.Rd);
        if (!this.missing && this.errVariance != 0.0) {
            this.loading.XpZd(pos, this.R, this.u);
            DataBlockIterator rcols = this.Rd.columnsIterator();
            DoubleSeqCursor.OnMutable ucur = this.U.cursor();
            while (rcols.hasNext()) {
                this.loading.XpZd(pos, rcols.next(), ucur.getAndNext());
            }
        }
        this.Rc.copy(this.R);
        this.Rc.addProduct(this.Rd.rowsIterator(), this.delta);
        this.Rc.apply(z -> Math.abs(z) < 1.0E-9 ? 0.0 : z);
    }

    private void iterateSmoothation(int pos) {
        if (this.missing) {
            this.u = Double.NaN;
            this.U.set(Double.NaN);
            return;
        }
        if (this.errVariance != 0.0) {
            this.u = this.err / this.errVariance - this.R.dot(this.K);
            this.U.product(this.K, this.Rd.columnsIterator());
            this.U.chs();
            this.U.addAY(1.0 / this.errVariance, this.E);
        } else {
            this.u = -this.R.dot(this.K);
            this.U.product(this.K, this.Rd.columnsIterator());
            this.U.chs();
        }
    }

    private void initFilter(ISsf ssf) {
        this.dynamics = ssf.dynamics();
        this.loading = ssf.loading();
    }

    public DefaultQFilteringResults getFilteringResults() {
        return this.frslts;
    }

    public DataBlock R(int pos) {
        return this.allR.block(pos);
    }

    public FastMatrix Rvar(int pos) {
        return this.allRvar.matrix(pos);
    }
}

