/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.r.arima;

import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.core.arima.ArimaModel;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.ssf.SsfException;
import jdplus.toolkit.base.core.ssf.arima.SsfUcarima;
import jdplus.toolkit.base.core.ssf.composite.CompositeSsf;
import jdplus.toolkit.base.core.ssf.dk.DkToolkit;
import jdplus.toolkit.base.core.ssf.univariate.DefaultSmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.SsfData;
import jdplus.toolkit.base.core.ucarima.IRootSelector;
import jdplus.toolkit.base.core.ucarima.ModelDecomposer;
import jdplus.toolkit.base.core.ucarima.SeasonalSelector;
import jdplus.toolkit.base.core.ucarima.TrendCycleSelector;
import jdplus.toolkit.base.core.ucarima.UcarimaModel;
import jdplus.toolkit.base.core.ucarima.WienerKolmogorovEstimator;
import jdplus.toolkit.base.core.ucarima.WienerKolmogorovEstimators;
import jdplus.toolkit.base.core.ucarima.WienerKolmogorovPreliminaryEstimatorProperties;
import jdplus.toolkit.base.protobuf.modelling.ModellingProtos;
import jdplus.toolkit.base.protobuf.modelling.ModellingProtosUtility;
import lombok.Generated;

public final class UcarimaModels {
    public static UcarimaModel of(ArimaModel model, ArimaModel[] components) {
        return UcarimaModel.builder().model((IArimaModel)model).add(components).build();
    }

    public static UcarimaModel decompose(SarimaModel sarima, double rmod, double epsphi) {
        TrendCycleSelector tsel = new TrendCycleSelector();
        if (rmod > 0.0) {
            tsel.setBound(rmod);
        }
        SeasonalSelector ssel = new SeasonalSelector(sarima.getPeriod());
        if (epsphi > 0.0) {
            ssel.setTolerance(epsphi);
        }
        ModelDecomposer decomposer = new ModelDecomposer();
        decomposer.add((IRootSelector)tsel);
        decomposer.add((IRootSelector)ssel);
        UcarimaModel ucm = decomposer.decompose((IArimaModel)sarima);
        ucm = ucm.setVarianceMax(-1, false);
        return ucm;
    }

    public static UcarimaModel doCanonical(UcarimaModel ucm, int cmp, boolean adjust) {
        return ucm.setVarianceMax(cmp, adjust);
    }

    public static double[] wienerKolmogorovFilter(UcarimaModel ucm, int cmp, boolean signal, int nweights) {
        WienerKolmogorovEstimators wks = new WienerKolmogorovEstimators(ucm);
        WienerKolmogorovEstimator wk = wks.finalEstimator(cmp, signal);
        return DoubleSeq.onMapping((int)nweights, (IntToDoubleFunction)wk.getWienerKolmogorovFilter().weights()).toArray();
    }

    public static double[] wienerKolmogorovFilterGain(UcarimaModel ucm, int cmp, boolean signal, int n) {
        WienerKolmogorovEstimators wks = new WienerKolmogorovEstimators(ucm);
        WienerKolmogorovEstimator wk = wks.finalEstimator(cmp, signal);
        DoubleUnaryOperator gain = wk.getWienerKolmogorovFilter().gainFunction();
        double[] g = new double[n];
        double q = Math.PI / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            double w = q * (double)i;
            g[i] = gain.applyAsDouble(w);
        }
        return g;
    }

    public static WienerKolmogorovEstimators wienerKolmogorovEstimators(UcarimaModel ucm) {
        return new WienerKolmogorovEstimators(ucm);
    }

    public static WienerKolmogorovEstimator finalEstimator(WienerKolmogorovEstimators wk, int cmp, boolean signal) {
        return wk.finalEstimator(cmp, signal);
    }

    public static double[] gain(WienerKolmogorovEstimator wk, int n) {
        DoubleUnaryOperator gain = wk.getWienerKolmogorovFilter().gainFunction();
        double[] g = new double[n];
        double q = Math.PI / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            double w = q * (double)i;
            g[i] = gain.applyAsDouble(w);
        }
        return g;
    }

    public static double[] filter(WienerKolmogorovEstimator wk, int n) {
        return DoubleSeq.onMapping((int)(n + 1), (IntToDoubleFunction)wk.getWienerKolmogorovFilter().weights()).toArray();
    }

    public static double[] spectrum(WienerKolmogorovEstimator wk, int n) {
        DoubleUnaryOperator s = wk.getEstimatorModel().getSpectrum().asFunction();
        double[] g = new double[n];
        double q = Math.PI / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            double w = q * (double)i;
            g[i] = s.applyAsDouble(w);
        }
        return g;
    }

    public static WienerKolmogorovPreliminaryEstimatorProperties preliminaryEstimators(WienerKolmogorovEstimators wk, int cmp, boolean signal) {
        WienerKolmogorovPreliminaryEstimatorProperties wkp = new WienerKolmogorovPreliminaryEstimatorProperties(wk);
        wkp.select(cmp, signal);
        return wkp;
    }

    public static Matrix estimate(double[] data, UcarimaModel ucm, boolean stdev) {
        ucm = ucm.simplify();
        CompositeSsf ssf = SsfUcarima.of((UcarimaModel)ucm);
        try {
            DefaultSmoothingResults rslt = DkToolkit.sqrtSmooth((ISsf)ssf, (ISsfData)new SsfData(data), (boolean)stdev, (boolean)true);
            int n = ucm.getComponentsCount();
            FastMatrix M = FastMatrix.make((int)data.length, (int)(stdev ? 2 * n : n));
            int[] pos = ssf.componentsPosition();
            for (int i = 0; i < n; ++i) {
                M.column(i).copy(rslt.getComponent(pos[i]));
                if (!stdev) continue;
                M.column(n + i).copy(rslt.getComponentVariance(pos[i]).fastOp(w -> w <= 0.0 ? 0.0 : Math.sqrt(w)));
            }
            return M;
        }
        catch (SsfException ex) {
            return null;
        }
    }

    public static byte[] toBuffer(UcarimaModel model) {
        ModellingProtos.UcarimaModel.Builder builder = ModellingProtos.UcarimaModel.newBuilder().setModel(ModellingProtosUtility.convert((IArimaModel)model.getModel(), (String)"model"));
        int j = 0;
        for (int i = 0; i < model.getComponentsCount(); ++i) {
            ArimaModel component = model.getComponent(i);
            if (component.isNull()) continue;
            builder.addComponents(ModellingProtosUtility.convert((IArimaModel)component, (String)("cmp-" + ++j)));
        }
        return builder.build().toByteArray();
    }

    @Generated
    private UcarimaModels() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

