% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests_seasonality.R
\name{seasonality_canovahansen_trigs}
\alias{seasonality_canovahansen_trigs}
\title{Canova-Hansen test using trigonometric variables}
\usage{
seasonality_canovahansen_trigs(
  data,
  periods,
  lag1 = TRUE,
  kernel = c("Bartlett", "Square", "Welch", "Tukey", "Hamming", "Parzen"),
  order = NA,
  original = FALSE
)
}
\arguments{
\item{data}{the input data.}

\item{periods}{Periodicities.}

\item{lag1}{Lagged variable in the regression model.}

\item{kernel}{Kernel used to compute the robust Newey-West covariance matrix.}

\item{order}{The truncation parameter used to compute the robust Newey-West covariance matrix.}

\item{original}{\code{TRUE} for original algorithm, \code{FALSE} for solution proposed by T. Proietti (based on Ox code).}
}
\value{
a numeric vector
}
\description{
Canova-Hansen test using trigonometric variables
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
s <- log(ABS$X0.2.20.10.M)
freqs <- seq(0.01, 0.5, 0.001)
sct <- seasonality_canovahansen_trigs(s, 1 / freqs, original = FALSE)
plot(sct, type = "l")
\dontshow{\}) # examplesIf}
}
