% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-standalone-df-list-df.R
\name{.list_of_lists_to_df}
\alias{.list_of_lists_to_df}
\title{Convert a multilevel list to a nested dataframe}
\usage{
.list_of_lists_to_df(lst, ...)
}
\arguments{
\item{lst}{a multilevel list}

\item{...}{
  Named arguments passed on to \code{\link[=.transpose]{.transpose}}\describe{
    \item{\code{x}}{a \code{data.frame} or \code{row_list}}
\item{\code{.fix}}{collapse or expand names in redundant multi-level \code{row_list}s.
Either \code{FALSE} or a string to join or split the names of the multi-level
list by}
\item{\code{...}}{not used}
}}
}
\value{
a dataframe with each sublist nested as a dataframe
}
\description{
Convert a multilevel list to a nested dataframe
}
\concept{transpose}
\keyword{internal}

\section{Unit tests}{
\if{html}{\out{<div class="sourceCode">}}\preformatted{

iris_list = .df_to_list_of_lists(iris, .fix=FALSE)
iris2 = .list_of_lists_to_df(iris_list, .fix=FALSE)

testthat::expect_equal(datasets::iris, as.data.frame(iris2))

mtcars_nest = datasets::mtcars %>%
  dplyr::mutate(name = rownames(.)) %>%
  tidyr::nest(details = -c(cyl,gear))

mtcars_list = mtcars_nest %>% .df_to_list_of_lists()

mtcars_nest2 = mtcars_list %>% .list_of_lists_to_df()

testthat::expect_equal(
  mtcars_nest2$details[[2]],
  mtcars_nest$details[[2]]
)

# test unequal length vector column is mapped to list of vectors
# and multiply named nests are treated as rows
testlist = list(
   row = list(a=1:5, b="x"),
   row = list(a=2:4, b="y"),
   row = list(a=3, b="z")
)
testdf = testlist %>% .list_of_lists_to_df()
testthat::expect_equal(testdf$b, c("x", "y", "z"))
testthat::expect_equal(testdf$a[[2]], 2:4)

}\if{html}{\out{</div>}}
}

