% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotOneFactor.r
\name{plotOneFactor}
\alias{plotOneFactor}
\title{Bar plot of gene expression from an expression table of a single-factor experiment data}
\usage{
plotOneFactor(
  data,
  x_col,
  y_col,
  Lower.se_col,
  Upper.se_col,
  letters_col = NULL,
  show.groupingLetters = TRUE
)
}
\arguments{
\item{data}{A data.frame such as the expression result of \code{ANOVA_DDCt(x)} or \code{ANOVA_DCt(x)}, etc. functions.}

\item{x_col}{The column number of the data.frame used for x axis.}

\item{y_col}{The column number of the data.frame used for y axis.}

\item{Lower.se_col}{The column number of the data.frame used for the lower error bar.}

\item{Upper.se_col}{The column number of the data.frame used for the upper error bar.}

\item{letters_col}{The column number of the data.frame used as the result of statistical comparing and grouping.}

\item{show.groupingLetters}{a logical variable. If TRUE, mean grouping letters (the results of statistical comparison) are added to the bars.}
}
\value{
Bar plot of the average fold change for target genes along with the significance and the standard error or 95\% confidence interval as error bars.
}
\description{
Bar plot of the relative expression of a gene along with the standard error (se), 95\% confidence interval (ci) and significance.
}
\details{
The \code{plotOneFactor} function generates the bar plot of the  fold change for target genes along with the significance and the 95\% confidence interval as error bars.
}
\examples{

# Before plotting, the result needs to be extracted as below:
res <- ANOVA_DCt(data_1factor, numberOfrefGenes = 1, block = NULL)$Result

# Bar plot
plotOneFactor(res, 1, 2, 7, 8, 11,
    show.groupingLetters = TRUE)


}
\author{
Ghader Mirzaghaderi
}
