% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_gt_dashboard.R
\name{st_gt_dashboard}
\alias{st_gt_dashboard}
\title{Create FiveThirtyEight-styled GT Dashboard from Top Charts Data}
\usage{
st_gt_dashboard(
  data,
  title = "Top Mobile Games",
  subtitle = NULL,
  ranking_metric = "revenue_180d_ww",
  show_demographics = TRUE,
  show_engagement = TRUE,
  show_retention = TRUE,
  retention_region = "us",
  show_rpd = TRUE,
  bar_charts = TRUE,
  bar_chart_columns = NULL,
  heatmap_retention = TRUE,
  compact_mode = TRUE,
  width = 1800,
  height = 700,
  save_path = NULL,
  icon_cache_dir = "inst/images/app_icons",
  raw = FALSE,
  color_scheme = list(revenue = "#FF6600", downloads = "#008FD5", engagement = "#9C27B0",
    rpd = "#4CAF50", retention_low = "#FFCDD2", retention_mid = "#C8E6C9", retention_high
    = "#4CAF50")
)
}
\arguments{
\item{data}{Data frame from st_top_charts() or similar Sensor Tower function}

\item{title}{Character string for the table title (default: "Top Mobile Games")}

\item{subtitle}{Character string for subtitle. If NULL, auto-generates based on data}

\item{ranking_metric}{Character string specifying which metric to use for ranking.
Options: "revenue_180d_ww", "revenue_30d_ww", "downloads_180d_ww", "downloads_30d_ww", etc.
(default: "revenue_180d_ww")}

\item{show_demographics}{Logical, whether to show demographic columns (age, gender)
(default: TRUE)}

\item{show_engagement}{Logical, whether to show engagement metrics (DAU, WAU, MAU)
(default: TRUE)}

\item{show_retention}{Logical, whether to show retention metrics
(default: TRUE)}

\item{retention_region}{Character string for retention region ("us", "ww", etc.)
(default: "us")}

\item{show_rpd}{Logical, whether to show Revenue Per Download
(default: TRUE)}

\item{bar_charts}{Logical, whether to show bar chart visualizations
(default: TRUE)}

\item{bar_chart_columns}{Character vector of column patterns to add bar charts to.
If NULL, applies to all numeric columns except RPD and retention.}

\item{heatmap_retention}{Logical, whether to apply heatmap to retention columns
(default: TRUE)}

\item{compact_mode}{Logical, whether to use compact row heights
(default: TRUE)}

\item{width}{Numeric, table width in pixels (default: 1800)}

\item{height}{Numeric, table height in pixels (default: 700)}

\item{save_path}{Character string, path to save the table image. If NULL, returns GT object}

\item{icon_cache_dir}{Character string, directory to cache app icons
(default: "inst/images/app_icons")}

\item{raw}{Logical, whether to return a minimally styled table without 
custom formatting, bar charts, or heatmaps (default: FALSE)}

\item{color_scheme}{List with color codes for different metric types:
- revenue: Revenue metrics color (default: "#FF6600")
- downloads: Downloads metrics color (default: "#008FD5")
- engagement: Engagement metrics color (default: "#9C27B0")
- rpd: RPD metrics color (default: "#4CAF50")
- retention_low: Low retention color (default: "#FFCDD2")
- retention_mid: Mid retention color (default: "#C8E6C9")
- retention_high: High retention color (default: "#4CAF50")}
}
\value{
GT object (if save_path is NULL) or saves image and returns path
}
\description{
Creates a professional, FiveThirtyEight-themed GT table dashboard from 
Sensor Tower top charts data with customizable styling and metric options.
}
\examples{
\dontrun{
# Basic usage - one line after st_top_charts()
top_rpgs <- st_top_charts(category = 7014, measure = "revenue")
st_gt_dashboard(top_rpgs)

# Raw mode for minimal styling
st_gt_dashboard(top_rpgs, raw = TRUE)

# Customize the dashboard
st_gt_dashboard(
  top_rpgs,
  title = "Top Role-Playing Games Q4 2024",
  ranking_metric = "revenue_30d_ww",
  show_retention = FALSE,
  save_path = "dashboard.png"
)

# Change color scheme
st_gt_dashboard(
  top_rpgs,
  color_scheme = list(
    revenue = "#E74C3C",
    downloads = "#3498DB",
    engagement = "#9B59B6"
  )
)
}
}
