% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{generate_cost_matrix}
\alias{generate_cost_matrix}
\title{Generate a simple cost matrix}
\usage{
generate_cost_matrix(charset, ambiguity_base = NULL, match = 0L, mismatch = 1L)
}
\arguments{
\item{charset}{A string of all allowed characters in both query and target sequences (e.g. \code{"ACGT"}).}

\item{ambiguity_base}{A single character (e.g. \code{"N"}) that will match any character in \code{charset} at the cost of \code{match}.  Defaults to \code{NULL}.}

\item{match}{Integer cost of a match.}

\item{mismatch}{Integer cost of a mismatch.}
}
\value{
A square cost matrix with row- and column-names given by \code{charset}, plus the optional \code{ambiguity_base}. Gap costs are no longer included here; pass \code{gap_cost} and \code{gap_open_cost} to distance/search functions.
}
\description{
Generate a cost matrix for use with the \code{search} method.
}
\examples{
generate_cost_matrix("ACGT", match = 0, mismatch = 1)
generate_cost_matrix("ACGT", ambiguity_base = "N", match = 0, mismatch = 1)
}
