% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vizAnnualClimate.R
\name{vizAnnualClimate}
\alias{vizAnnualClimate}
\title{Annual Climate Summaries for Soil Series Data}
\usage{
vizAnnualClimate(climate.data, IQR.cex = 1, s = NULL, s.col = "firebrick", ...)
}
\arguments{
\item{climate.data}{Annual climate summaries, as returned from \code{soilDB::fetchOSD(..., extended = TRUE)}, should not contain NA values}

\item{IQR.cex}{scaling factor for bar representing interquartile range}

\item{s}{a soil series name, e.g. "LUCY", to highlight}

\item{s.col}{color for highlighted soil series}

\item{...}{further arguments passed to \code{latticeExtra::segplot}}
}
\value{
A \code{list} with the following elements:
\itemize{
\item \code{fig}: lattice object (the figure)
\item \code{clust}: clustering object returned by \code{cluster::diana}
}
}
\description{
Annual climate summaries for soil series, based on \code{latticeExtra::segplot}, based on 5th, 25th, 50th, 75th, and 95th percentiles. Input data should be from \code{soilDB::fetchOSD}.
}
\details{
This function was designed for use with \code{soilDB::fetchOSD()}. It might be possible to use with other sources of data but your mileage may vary. See the \href{http://ncss-tech.github.io/AQP/soilDB/soil-series-query-functions.html}{Soil Series Query Functions} tutorial for more information.
}
\seealso{
\code{\link[=vizHillslopePosition]{vizHillslopePosition()}}
}
\author{
D.E. Beaudette
}
